/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: GetProductVo
 * @Package cn.freemud.entities.vo
 * @Description:
 * @author: liming.guo
 * @date: 2018/5/16 17:35
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.vo;

import cn.freemud.entities.dto.UserDeliveryInfoDto;
import cn.freemud.entities.dto.delivery.WeixinDeliveryAddressDto;
import cn.freemud.entities.vo.order.*;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import org.hibernate.validator.constraints.NotEmpty;

import javax.validation.Valid;
import javax.validation.constraints.Pattern;
import java.util.List;


@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class CreateOrderVo {

    @NotEmpty(message = "sessionId 不能为空")
    private String sessionId;

    private String partnerId;

    //@NotEmpty(message = "门店ID 不能为空")  //本次需要根据业务做校验
    private String shopId;

    /**
     *  爱马哥蛋糕预定
     *  预定单需求, bizType= 7  其他的场景默认传递null
     */
    private Integer bizType;

    /**
     * 就餐人数　(围餐参数)
     */
    private Integer peopleNumber;

    /**
     * 操作标识　(围餐参数)
     */
    private Integer operation;

    /**
     * 购物车版本号 (围餐参数)
     */
    private Integer carVer;

    /**
     * 下单版本号 (围餐参数)
     */
    private Integer orderUpdateVer;

    //内部参数
    private String thirdShopId;

    //内部参数
    private String storeName;

    //内部参数
    private String storeNameEn;

    //内部参数　入参不需要传　
    private String storeAddress;

    //内部参数
    private String userId;

    //内部参数
    private String userName;

    //内部参数
    private String mobile;

    //抖音卖券参数
    private String saleCouponPhone;

    /**
     * 渠道 1 saas 2 支付宝  3. iwc i围餐　5 头条
     * @see  cn.freemud.enums.ChannelEnum
     */
    private String channel;
    /**
     * 订单类型  1 到店自取 2 外卖   枚举CreateOrderType
     */
    //@NotNull(message = "下单类型不能为空")
    private Integer orderType;

    /**
     * 拼单参数
     * 订单特殊类型 1:普通订单 2:拼团订单 3:秒杀订单 4:拼单订单
     * @see com.freemud.application.sdk.api.ordercenter.enums.MarketTypeEnum
     */
    private Byte marketingType;

    /**
     * 到店类型  orderType 传1的时候    如果reachStoreTyp为空转成订单类型4  如果不为空存储4(打包带走)和5（店内就餐）
     */
    private Integer reachStoreType;

    /**
     * 桌号 桌号点餐必传
     */
    private String tableNumber;

    /**
     * 取餐时间
     */
    private String takeMealTime;

    /**
     * 预约时间 格式yyyy-MM-dd HH:mm:ss
     * 麦咖啡返回的是yyyy-MM-dd HH:mm
     */
    private String expectTime;

    /**
     * 取餐标识 0=我已到店、尽快送出 1预约单
     */
    private String takeMealFlag;
    /**
     * 是否外带 ,打包  1 是 0 否
     */
//    private Integer takeOut;
    /**
     * 订单备注
     */
    private String orderRemark;
    /**
     * 收货地址ID
     */
    private String receiveId;

    //内部参数 收货地址
    private String receiveAddress;

    //内部参数 收货用户名
    private String receiveUsername;

    //内部参数 收货电话
    @Pattern(regexp = "^1[3|4|5|6|7|8|9][0-9]{9}$", message = "手机号码格式不正确")
    private String receiveMobile;

    /**
     * 内部参数
     * 用户收货地址信息 ，入参不需要传,通过校验receiveId获取
     */
    public UserDeliveryInfoDto userDeliveryInfoDto;

    /**
     * 用户定义纬度
     */
    private String latitude;
    /**
     * 用户定义经度
     */
    private String longitude;

    /**
     * 券码
     */
    private String couponCode;

    /**
     * 券码列表
     */
    private List<CreateOrderCouponCodeVo> couponCodes;

    /**
     * 运费券code
     */
    private String freightCouponCode;
    /**
     * 版本号
     */
    private String version;
    /**
     * 前端参数
     * form_id  用于金额是0的情况,支付宝消息通知中下单通知必传
     */
    private String formId;

    /**
     * 下单支付渠道类型
     */
    private Byte payChannelType;

    @Valid
    private CreateOrderPremiumExchangeActivityVo premiumExchangeActivity;

    /**
     * coco 买一赠一寄杯
     * 买一赠一选择的商品
     */
    private List<CreateOrderChooseGoodVo> chooseGoods;

    /**
     * 是否使用用户积分
     * 1=不显示积分
     * 2=显示积分但不扣减
     * 3=显示积分且扣减
     */
    private Integer useCustomerScore;
    /**
     * 会员卡信息
     */
//    @Deprecated
//    private BuyMemberCard buyMemberCard;

    /**
     * svc 卡支付使用
     */
    private String cardCode;

    private List<String> cardCodes;

    /**
     * 扫脸支付使用
     */
    private String faceCode;

    /**
     * 随单购啡常月享卡键位
     */
    private String cardKeyCode;

    @ApiModelProperty(hidden = true)
    private String sessionKey; // 存储sessionKey,异常补退使用
    @ApiModelProperty(hidden = true)
    private String scene;// 打开小程序的场景值

    @Builder.Default
    private String menuType = "saas";
    /**
     * 渠道类型 OrderChannelType
     */
    private String channelType;

    /**
     * 麦咖啡请求参数
     * 是否需要餐具，1 需要 0不需要
     */
    private Integer needTableware;

    /**
     * 麦咖啡请求参数
     * 是否需要开发票，1 需要 0不需要
     */
    private Integer needInvoice;

    /**
     * 麦咖啡请求参数
     * 发票抬头
     */
    private String invoiceTitle;

    /**
     *  麦咖啡请求参数
     * 随单购是否购买月享卡 1:不购买，2：月卡续费，3：新购月卡
     */
    private String buyMonthlyCard;

    // 麦咖啡请求参数
    private String monthlyCardCode;

    /**
     * 预定单的 您的电话
     */
    private String userPhone;
    /**
     *  预定单 蛋糕寄语(额外祝福语) 最多20个字
     */
    private String sendWord;

    /**
     * 【华莱士】【订单C端记录不分账的卡面编号】不让走分账，卡面编号--11840，11845，11846，11853，11854，11855，11857，11858，11859，11860，11861，11862，11863，11864，11865，11866，11906
     *
     *  1 表示不分账 ,其他情况 不传值 给基础服务
     */
//    private Integer unDistribution;

    /**
     * 是否使用电子风味卡,如果不为空则为使用
     */
    @Valid
    @ApiModelProperty(value = "电子风味卡")
    private CreateOrderUnionPayCardVo unionPayCard;

    /**
     * 下单商品，积分商城使用
     */
    private List<CreateOrderProductVo> products;

    /**
     * 微信配送地址信息
     */
    private WeixinDeliveryAddressDto weixinDeliveryAddress;

    /**
     * 微商城立即购买场景新增
     * 购买类型 0=普通购买 1=立即购买 ，默认值为普通购买
     */
    private int buyType = 0;

    /**
     * 使用户省份code 100010 这是微信选择地址传过来的，用户查询配送费用的， 并不是北京市这种给是
     */
    private String province;

    /**
     * 收货名姓名
     */
    private String contactsName;

    @ApiModelProperty(value = "是否与营销活动共享 1-是 0-否")
    private Integer enableSharing = 1;

}
