package com.freemud.sdk.api.assortment.order.response.order;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 聚合退款返回
 */
@Data
public class MultiOrderRefundResponse<T> {
    private int code;

    private String msg;

    private RefundPlatform data;

    @Data
    public static class RefundPlatform {
        public List<RefundPlatformResponse> refundPlatformResponseList;
    }

    @Data
    public static class RefundPlatformResponse {

        /**
         * 退款中状态码需要单独处理
         */
        public static Integer REFUNDED_RESULTCODE = 8200305;
        /**
         * 退款成功
         */
        public static Integer REFUND_SUCCESS = 100;
        private String endTransTradeNo;
        private String fmRefundNo;
        private String fmTradeNo;
        private Integer mcouponAmount;
        private Integer pcouponAmount;
        private String platformTradeNo;
        private Integer refundAmount;
        private String refundCurrency;
        private String refundDesc;
        private String refundEndTransTradeNo;
        private String refundTime;
        private String refundTradeNo;
        private Integer settleRefundAmount;
        private Integer totalAmount;
        private String transId;
        private String ebcode;

        @ApiModelProperty(value = "业务返回码 8200305 代表退款中   100是成功  其他  都是失败")
        private Integer resultCode;

        @ApiModelProperty(value = "业务返回消息")
        private String resultMsg;
    }
}