/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: ProductInfosDto
 * @Package cn.freemud.entities.dto
 * @Description:
 * @author: liming.guo
 * @date: 2018/5/28 21:11
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.dto;

import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@NoArgsConstructor
@Data
public class ValidateProductInfosDto {

    private DataBean data;
    private Integer errcode;
    private Integer code;
    private String errmsg;

    @NoArgsConstructor
    @Data
    public static class DataBean {

        private Integer count;
        private List<ProductData> failureList;
        private List<ProductData> successList;
    }
    @NoArgsConstructor
    @Data
    public static class ProductData {
        private ProductBean productType;
    }
    @NoArgsConstructor
    @Data
    public static class ProductBean {

        private String barcode;
        private String brandId;
        private String brandName;
        private String category;
        private String categoryName;
        private String companyId;
        private String customerCode;
        /**
         * 最终价格 单位分
         */
        private Long finalPrice;
        /**
         * 是否是SKU商品  1是0否
         */
        private Integer isSkuProduct;
        private String name;
        /**
         * 原始价格 单位分
         */
        private Long originalPrice;
        /**
         * 包装费 单位分
         */
        private Long packPrice;

        private String picture;
        private String pid;
        private Integer pknumber;
        private String productionLocation;
        private String remark;
        private Integer saleCount;
        private String sellTimeName;
        private Integer sequence;
        private String sourceChannel;
        private String specification;
        private Integer status;
        private Integer stock;
        private Integer stockLimit;
        private String detailText;
        /**
         * type=10 多规格  type=1 单规格
         */
        private int type;
        private String unit;
        private int updateStatus;
        private boolean valid;
        private int version;
        private List<ProductLabelNameListBean> labelNames;
        private List<ProductAttributeGroupListBean> productAttributeGroupList;
        private List<ProductPictureListBean> productPictureList;
        private List<?> productSpecification;
        //                        private List<?> sellTimeList;
        private List<?> specificationList;
        //SKU
        private List<SkuProductBean> skuList;
        //规格信息
        private List<SpecificationGroupBean> specificationGroupList;
        //Sku 规格 如果 当前是sku 则有值
        private List<SkuProductBean.SkuSpecValue> skuSpecValues;

        /**
         * 套餐商品固定搭配子商品列表 1.9.2
         */
        private List<ProductComboListBean> productComboList;

        /**
         * 商品组表 1.9.2 套餐可选搭配
         */
        private List<ProductGroupListBean> productGroupList;

        /**
         * 1.9.3.1 商品可售时间
         */
        private List<SellTime> sellTimeList;

        @Data
        public static class SellTime{
            private Integer dateStatus;
            private String startTime;
            private String endTime;
        }
        private List<SellTimeMonth> sellTimeMonthList;
        @Data
        public static class SellTimeMonth{
            private Integer dayOfMonth;
            private String endTime;
            private String startTime;
        }

        @NoArgsConstructor
        @Data
        public static class SkuProductBean {
            private Long finalPrice;
            private Long originalPrice;
            private String productName;
            private Integer productType;
            private Integer sequence;
            private String skuCode;
            private String skuId;

            private Integer status;
            //以下两个字段 1.5.4新加
            private Integer stockLimit;
            private Integer stockQty;
            //sku商品包装费 1.5.4新加
            private Long packPrice ;
            private List<SkuSpecValue> skuSpecValues;

            @NoArgsConstructor
            @Data
            public static class SkuSpecValue {
                private String productId;
                private Integer sequence;
                private String specId;
                private String specName;
                private String specValue;
                private String specValueId;
            }
        }

        @NoArgsConstructor
        @Data
        public static class SpecificationGroupBean {
            private String partnerId;
            private Integer sequence;
            private String specId;
            private String specName;
            private List<SpecValueVo> specValueVos;

            @NoArgsConstructor
            @Data
            public static class SpecValueVo {
                private Integer sequence;
                private String specId;
                private String specValue;
                private String specValueId;
            }
        }

        @NoArgsConstructor
        @Data
        public static class ProductLabelNameListBean {
            private String id;
            private String name;
            private String partnerId;
            List<?> productList;
            private String storeId;
            private String type;
        }

        @NoArgsConstructor
        @Data
        public static class ProductAttributeGroupListBean {
            /**
             * attributeName : 加料
             * attributeType : 1
             * attributeValues : [{"attributeValue":"","id":0,"price":0,"sequence":0,"status":0}]
             */

            /**
             * 属性名称
             */
            private String attributeName;
            /**
             * 属性类型
             */
            private Integer attributeType;
            /**
             * 属性详细信息
             */
            private List<AttributeValueBean> attributeValues;

            @NoArgsConstructor
            @Data
            public static class AttributeValueBean {
                /**
                 * attributeValue :
                 * id : 0
                 * price : 0
                 * sequence : 0
                 * status : 0
                 */
                /**
                 * 属性值
                 */
                private String attributeId;

                private String attributeValue;
                /**
                 * 属性ID
                 */
                private Long id;
                /**
                 *
                 */
                private Long price;
                private Integer sequence;
                private Integer status;
            }
        }

        @NoArgsConstructor
        @Data
        public static class ProductPictureListBean {
            /**
             * pictureId : 107901339444445753
             * productId : 107901318808470072
             * sequence : 0
             * type : default
             * url : http://ojcpa0rpt.bkt.clouddn.com/xianfengfruit_DishPool_default_30b5f0ca-399a-4be3-9063-12a3d2622a38_1513952518.jpg
             */

            private String pictureId;
            private String productId;
            private String sequence;
            private String type;
            private String url;
        }
        @NoArgsConstructor
        @Data
        public static class ProductComboListBean {
            /**
             * upc
             */
            private String barcode;
            /**
             * 商品后台分类编码
             */
            private String category;
            /**
             * 商品后台分类
             */
            private String categoryName;
            /**
             * 第三方商品编码
             */
            private String customerCode;
            /**
             * 最终售价
             */
            private Integer finalPrice;
            /**
             * 标签列表
             */
            private List<ProductLabelNameListBean> labelNames;
            /**
             * 扩展字段
             */
            private String options;
            /**
             * 标准售价
             */
            private Integer originalPrice;
            /**
             * 包装费
             */
            private Integer packPrice;
            /**
             * 商品默认图片
             */
            private String picture;
            /**
             * 商品Code
             */
            private String productCode;
            /**
             * 商品ID
             */
            private String productId;
            /**
             * 商品名称
             */
            private String productName;
            /**
             * 商品类型 /1普通商品/3组合商品/6套餐/7加价套餐/9虚拟商品/10多规格商品
             */
            private Integer productType;
            /**
             * 商品数量
             */
            private Integer quantity;
            /**
             * 排序
             */
            private Integer sequence;
            /**
             * 规格
             */
            private String specification;
            /**
             * 商品状态 /1下架/2上架/3售罄/4删除
             */
            private Integer status;
            /**
             * 是否设置库存
             */
            private Integer stockLimit;
            /**
             * 单位
             */
            private String unit;
        }

        @NoArgsConstructor
        @Data
        public static class ProductGroupListBean {
            /**
             * 创建时间
             */
            private String createDate;
            /**
             * 商品组编号，跟groupId一样确认商品组唯一的字段
             */
            private String groupCode;
            /**
             * 商品组详情集合
             */
            private List<ProductGroupListBean.GroupDetailBean> groupDetail;
            /**
             * 商户ID
             */
            private String linkId;
            /**
             * 商品组规则-选择的最大数量
             */
            private Integer maxNumber;
            /**
             * 商品组规则-选择的最小数量
             */
            private Integer minNumber;
            /**
             * 商品组规则-是否必选
             */
            private Integer must;
            /**
             * 商品组名
             */
            private String name;
            /**
             * 扩展字段
             */
            private String options;
            /**
             * 商品组ID
             */
            private String pgid;
            /**
             * 商品组备注
             */
            private String remark;
            /**
             * 更新时间
             */
            private String updateDate;

            @NoArgsConstructor
            @Data
            public static class GroupDetailBean {
                /**
                 * upc
                 */
                private String barcode;
                /**
                 * 商品后台分类编码
                 */
                private String category;
                /**
                 * 商品后台分类
                 */
                private String categoryName;
                /**
                 * 第三方商品编码
                 */
                private String customerCode;
                /**
                 * 商品组ID
                 */
                private String groupId;
                /**
                 * 是否默认商品，1是0否
                 */
                private Integer isDefault;
                /**
                 * 标签列表
                 */
                private List<ProductLabelNameListBean> labelNames;
                /**
                 * 加价价格
                 */
                private Integer markUpPrice;
                /**
                 * 扩展字段
                 */
                private String options;
                /**
                 * 商品默认图片
                 */
                private String picture;
                /**
                 * 商品Code
                 */
                private String productCode;
                /**
                 * 最终售价
                 */
                private Integer productFinalPrice;
                /**
                 * 商品ID
                 */
                private String productId;
                /**
                 * 商品名称
                 */
                private String productName;
                /**
                 * 标准售价
                 */
                private Integer productPrice;
                /**
                 * 商品类型 /1普通商品/3组合商品/6套餐/7加价套餐/9虚拟商品/10多规格商品
                 */
                private Integer productType;
                /**
                 * 排序
                 */
                private Integer sequence;
                /**
                 * 规格
                 */
                private String specification;
                /**
                 * 商品状态 /1下架/2上架/3售罄/4删除
                 */
                private Integer status;
                /**
                 * 是否设置库存
                 */
                private Integer stockLimit;
                /**
                 * 单位
                 */
                private String unit;
            }
        }
    }
}