package cn.freemud.entities.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.hibernate.validator.constraints.NotEmpty;

/**
 * @author liming.guo
 * @date 2018/05/08
 */
@Data
public class GetUserLoginSessionIdVo {

    /**
     * 用户code，获取openid
     */
    @ApiModelProperty(value = "加密code", name = "code", required = true)
    @NotEmpty(message = "code 不能为空")
    private String code;

    /**
     * 商户id
     */
    @ApiModelProperty(value = "商户partnerId", name = "partnerId", required = true)
    @NotEmpty(message = "partnerId 不能为空")
    private String partnerId;

    /**
     * 小程序appId
     */
    @ApiModelProperty(value = "微信appid", name = "appid", required = true)
    @NotEmpty(message = "appid 不能为空")
    private String appId;

    /**
     * 小程序版本号 1.5.0
     */
    @ApiModelProperty(value = "小程序版本信息", name = "version")
    private String version;
        
    @ApiModelProperty(value = "设备品牌", name = "devBrand")
//    @NotEmpty(message = "devBrand 不能为空")
    private String devBrand;
    
    @ApiModelProperty(value = "设备型号", name = "devModel")
//    @NotEmpty(message = "devModel 不能为空")
    private String devModel;
    
    @ApiModelProperty(value = "登录渠道", name = "channel")
//    @NotEmpty(message = "channel 不能为空")
    private String channel;
    
    @ApiModelProperty(value = "客户端事件发生毫秒时间戳", name = "cts")
//    @NotEmpty(message = "cts 不能为空")
    private String cts;


    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

}
