package cn.freemud.management.thirdparty;

import cn.freemud.management.entities.dto.request.coupon.MCCafeCouponLockRequest;
import cn.freemud.management.entities.dto.request.coupon.MCCafeCouponRequest;
import com.freemud.application.sdk.api.couponcenter.offline.response.CouponBaseResponse;
import com.freemud.application.sdk.api.couponcenter.offline.response.CouponQueryResponse;
import com.freemud.application.sdk.api.couponcenter.offline.response.CouponRedeemResponse;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@FeignClient(name = "COUPONMCCafe",url="http://coupon-api-gateway-koderover-dev-coupon.api-ingress.sandload.cn")
@RequestMapping(produces = {"application/json;charset=UTF-8"})
public interface CouponOfflineMCCafeClient {

    // 核销优惠券
    @PostMapping("/mccafe/redeem")
    CouponRedeemResponse redeem(MCCafeCouponRequest mcCafeConponRequest);

    @PostMapping("/mccafe/cancelRedeem")
    CouponRedeemResponse cancelRedeem(MCCafeCouponRequest mcCafeConponRequest);

    @PostMapping("/mccafe/query")
    CouponQueryResponse query(MCCafeCouponRequest mcCafeConponRequest);

    // 优惠券锁定
    @PostMapping("/mccafe/lock")
    CouponBaseResponse lock(MCCafeCouponLockRequest MCCafeCouponLockRequest);

    //优惠券解锁
    @PostMapping("/mccafe/unlock")
    CouponBaseResponse unlock(MCCafeCouponLockRequest MCCafeCouponLockRequest);
}
