package cn.freemud.management.service;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.management.entities.dto.request.order.McCafeOrderManagerRequest;
import cn.freemud.management.entities.dto.request.order.OrderManagerRequest;
import cn.freemud.management.entities.dto.response.order.OrderManagerResponse;
import com.freemud.sdk.api.assortment.order.response.order.QueryOrdersResponse;

/**
 * 订单操作接口
 */
public interface OrderManagerService {

    /**
     * 接单
     * @param request 请求参数
     * @param orderBean 订单实体
     * @return
     */
    BaseResponse<OrderManagerResponse> orderConfirm(OrderManagerRequest request, QueryOrdersResponse.DataBean.OrderBean orderBean);

    /**
     * 麦咖啡接单
     * @param request 请求参数
     * @param orderBean 订单实体
     * @return
     */
    BaseResponse mcCafeOrderConfirm(McCafeOrderManagerRequest request, QueryOrdersResponse.DataBean.OrderBean orderBean);

    /**
     * 制作完成
     * @param request
     * @param orderBean
     * @return
     */
    BaseResponse<OrderManagerResponse> orderDone(OrderManagerRequest request, QueryOrdersResponse.DataBean.OrderBean orderBean);

    /**
     * 订单配送
     * @param request
     * @param orderBean
     * @return
     */
    BaseResponse<OrderManagerResponse> orderDelivery(OrderManagerRequest request, QueryOrdersResponse.DataBean.OrderBean orderBean);

    /**
     * 订单完成
     * @param request
     * @param orderBean
     * @return
     */
    BaseResponse<OrderManagerResponse> orderAffirm(OrderManagerRequest request, QueryOrdersResponse.DataBean.OrderBean orderBean);

    /**
     * 拒单
     * @param request
     * @param orderBean
     * @return
     */
    BaseResponse<OrderManagerResponse> orderReject(OrderManagerRequest request, QueryOrdersResponse.DataBean.OrderBean orderBean);

    /**
     * 麦咖啡拒单
     * @param request
     * @param orderBean
     * @return
     */
    BaseResponse mcCafeOrderReject(McCafeOrderManagerRequest request, QueryOrdersResponse.DataBean.OrderBean orderBean);

    /**
     * 同意退款
     * @param request
     * @param orderBean
     * @return
     */
    BaseResponse<OrderManagerResponse> orderAgreeRefund(OrderManagerRequest request, QueryOrdersResponse.DataBean.OrderBean orderBean);

    /**
     * 拒绝退款
     * @param request
     * @param orderBean
     * @return
     */
    BaseResponse<OrderManagerResponse> orderRejectRefund(OrderManagerRequest request, QueryOrdersResponse.DataBean.OrderBean orderBean);


}
