package cn.freemud.management.entities.dto.request.order;

import cn.freemud.management.enums.OperateType;
import lombok.Data;
import org.hibernate.validator.constraints.NotEmpty;

import javax.validation.constraints.Size;

@Data
public class McCafeOrderManagerRequest {

    /**
     * 商户号
     */
    @NotEmpty(message = "商户号不允许为null")
    private String partnerId;

    /**
     * 门店号
     */
    private String storeId;

    /**
     * 取餐码
     */
    private String pickUpGoodsNo;

    /**
     * 订单号
     */
    @NotEmpty(message = "订单号不允许为nul")
    private String orderId;

    /**
     * 订单操作类型
     * @see OperateType
     */
    @NotEmpty(message = "操作类型不能为空")
    private String operateType;

    /**
     * 操作人
     * pos
     * 开放平台
     * 小助手
     * 系统自动履单
     */
    @NotEmpty(message = "操作人不能为空")
    private String operator;
}
