package cn.freemud.service.thirdparty;

import cn.freemud.entities.dto.delivery.GetFilterPartnerResponse;
import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.vo.SendOrderCountsMsg;
import com.freemud.application.sdk.api.ordercenter.response.OrderCountResp;
import com.freemud.application.sdk.api.ordercenter.response.OrderGetPartnerRequest;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.List;

/**
 * @author : xh.Z
 * @email : fisherman0510@163.com
 * @Date : 2021/4/27 下午2:03
 * @description :
 */
@FeignClient(name = "MICRO-OPENPLATFORM")
@RequestMapping(consumes = MediaType.APPLICATION_JSON_UTF8_VALUE, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public interface MicroOpenplatformClient {

    /**
     * 上报微信 有数 统计数据
     *
     * @param orderCounts
     * @return
     */
    @PostMapping("/thirdApp/order/addOrderSum")
    BaseResponse addOrderSum(@RequestBody SendOrderCountsMsg orderCounts);


    /**
     * 获取需要 上报腾讯有数的 商户号
     *
     * @return
     */
    @PostMapping("/thirdApp/getFilterPartner")
    BaseResponse<GetFilterPartnerResponse> getFilterPartner(@RequestBody OrderGetPartnerRequest request);

}
