package cn.freemud.service.universal.factory;

import cn.freemud.entities.vo.CreateOrderAppVo;
import cn.freemud.entities.vo.CreateOrderBaseVo;
import cn.freemud.entities.vo.CreateOrderSaasMallVo;
import cn.freemud.entities.vo.CreateOrderSaasVo;
import cn.freemud.enums.CreateOrderSceneEnum;
import cn.freemud.enums.OrderChannelType;
import cn.freemud.enums.ResponseResult;
import cn.freemud.enums.UserLoginChannelEnum;
import cn.freemud.interceptor.ServiceException;
import cn.freemud.service.CheckOrderUniversal;
import cn.freemud.service.impl.CheckOrderApp;
import cn.freemud.service.impl.CheckOrderSaas;
import cn.freemud.service.impl.CheckOrderSaasMall;
import cn.freemud.service.universal.UniversalOrderService;
import cn.freemud.service.universal.impl.AppOrderService;
import cn.freemud.service.universal.impl.SaasMallOrderService;
import cn.freemud.service.universal.impl.SaasOrderService;
import com.alibaba.fastjson.JSON;
import com.freemud.api.assortment.datamanager.entity.vo.AssortmentCustomerInfoVo;
import com.freemud.api.assortment.datamanager.enums.IappIdType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

import java.util.Map;
import java.util.Objects;

@Service
public class CreateOrderServiceFactory {

    @Autowired
    private ApplicationContext applicationContext;

    /**
     * 获取对应的下单实体类操作
     *
     * @param param
     * @param assortmentCustomerInfoVo
     * @return
     */
    public CreateOrderSceneEnum getCreateOrderScene(Map<String, Object> param, AssortmentCustomerInfoVo assortmentCustomerInfoVo) {
        // 围餐
        if (IappIdType.WC_XCX.getCode().equals(assortmentCustomerInfoVo.getIappId())) {  //i围餐
            if (true) {
                // 围餐 暂时不接入
                throw new ServiceException(ResponseResult.SYSTEM_BUSINESS_ERROR, "围餐暂不接入");
            }
            return CreateOrderSceneEnum.MEAL;
        }
        if (UserLoginChannelEnum.APP.getCode().equals(assortmentCustomerInfoVo.getChannel())) {
            // APP订单
            return CreateOrderSceneEnum.APP;
        }
        Object channelType = param.get("channelType");
        if (Objects.nonNull(channelType)
                && (OrderChannelType.SAASMALL.getCode().equals(channelType))) {
            // 商城订单
            return CreateOrderSceneEnum.SAASMALL;
        }
        // 其他类型 为saas订单
        return CreateOrderSceneEnum.SAAS;
    }

    /**
     * 获取实体类对应 调用参数
     * fisherman 各个订单的入参类型 暂时没区分
     * @param param
     * @param createOrderSceneEnum
     * @return
     */
    public CreateOrderBaseVo getCreateOrderVo(Map<String, Object> param, CreateOrderSceneEnum createOrderSceneEnum) {
        switch (createOrderSceneEnum) {
            case SAAS: // SAAS
                return JSON.parseObject(JSON.toJSONString(param), CreateOrderSaasVo.class);
            case SAASMALL: // 商城
                return JSON.parseObject(JSON.toJSONString(param), CreateOrderSaasMallVo.class);
            case APP: // APP订单
                return JSON.parseObject(JSON.toJSONString(param), CreateOrderAppVo.class);
            default:
                throw new ServiceException(ResponseResult.SYSTEM_BUSINESS_ERROR, "CreateOrderSceneEnum 类型错误 :" + createOrderSceneEnum);
        }
    }

    /**
     * 获取真实操作对象
     *
     * @param createOrderSceneEnum
     * @return
     */
    public UniversalOrderService getCreateOrderService(CreateOrderSceneEnum createOrderSceneEnum) {
        switch (createOrderSceneEnum) {
            case SAAS:
                return applicationContext.getBean("saasOrderService", SaasOrderService.class);
            case SAASMALL:
                return applicationContext.getBean("saasMallOrderService", SaasMallOrderService.class);
            case APP:
                return applicationContext.getBean("appOrderService", AppOrderService.class);
                // 不支持围餐订单
//            case MEAL:
//                return applicationContext.getBean("mealOrderService", MealOrderService.class);
            default:
                return applicationContext.getBean("saasOrderService", SaasOrderService.class);
        }
    }

    /**
     * 获取校验对象
     *
     * @param createOrderSceneEnum
     * @return
     */
    public CheckOrderUniversal getCheckOrderService(CreateOrderSceneEnum createOrderSceneEnum) {
        switch (createOrderSceneEnum) {
            case SAAS:
                return applicationContext.getBean("checkOrderSaas", CheckOrderSaas.class);
            case SAASMALL:
                return applicationContext.getBean("checkOrderSaasMall", CheckOrderSaasMall.class);
            case APP:
                return applicationContext.getBean("checkOrderApp", CheckOrderApp.class);
            default:
                return applicationContext.getBean("checkOrderSaas", CheckOrderSaas.class);
        }
    }
}
