package cn.freemud.service.thirdparty;

import cn.freemud.entities.dto.GetMemberListRequestDto;
import cn.freemud.entities.dto.GetMemberListResponseDto;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@FeignClient(name = "CUSTOMER-TOOLS-SERVICE", url = "${saas.customertools.feign.url}")
@RequestMapping(produces = {"application/json;charset=UTF-8"})
public interface MemberToolsClient {

    /**
     * 根据会员手机号和商户获取会员信息
     */
    @PostMapping(value = "/customerservice/getMembers")
    GetMemberListResponseDto getMemberList(@RequestBody GetMemberListRequestDto getMemberListRequestDto);
}
