package cn.freemud.service.impl;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.constant.ResponseCodeConstant;
import cn.freemud.entities.bo.CreateOrderBo;
import cn.freemud.entities.dto.shoppingCart.GetShoppingCartGoodsApportionDto;
import cn.freemud.entities.dto.shoppingCart.ShoppingCartGoodsDto;
import cn.freemud.entities.vo.CreateOrderBaseVo;
import cn.freemud.entities.vo.ShoppingCartInfoRequestVo;
import cn.freemud.enums.OrderChannelType;
import cn.freemud.enums.ResponseResult;
import cn.freemud.interceptor.ServiceException;
import cn.freemud.service.CheckOrderUniversal;
import cn.freemud.service.order.OrderRelationFactory;
import cn.freemud.service.universal.CommonCheckOrderHandle;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.freemud.api.assortment.datamanager.manager.AssortmentOpenPlatformIappWxappConfigManager;
import org.apache.commons.lang.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CheckOrderSaas extends CheckOrderUniversal {

    @Override
    protected OrderChannelType getChannelType() {
        return OrderChannelType.SAAS;
    }

    @Autowired
    private CommonCheckOrderHandle commonCheckOrderHandle;

    @Autowired
    private OrderRelationFactory orderRelationFactory;

    @Autowired
    private AssortmentOpenPlatformIappWxappConfigManager openPlatformIappWxappConfigManager;

    // 配送费逻辑是否使用旧的
    @Value("${store.delivery.use.old}")
    private boolean storeDeliveryUseOld;

    @Value("${coco.partnerId}")
    private String cocoPartnerId;

    /**
     * 校验购物车优惠信息请求对象
     *
     * @param createOrderVo
     * @param shoppingCartInfoRequestVo
     * @return
     */
    @Override
    protected GetShoppingCartGoodsApportionDto getShoppingCartGoodsApportionDto(CreateOrderBaseVo createOrderVo, ShoppingCartInfoRequestVo shoppingCartInfoRequestVo) {
        GetShoppingCartGoodsApportionDto requestDto = new GetShoppingCartGoodsApportionDto();
        // 设置用户选择的买一赠一商品信息
        shoppingCartInfoRequestVo.setChooseGoods(JSONArray.parseArray(JSONObject.toJSONString(createOrderVo.getChooseGoods()), ShoppingCartInfoRequestVo.ChooseGood.class));
        requestDto.setShoppingCartInfoRequestVo(shoppingCartInfoRequestVo);
        //加价购商品 校验放购物车校验
        requestDto.setPremiumExchangeActivity(createOrderVo.getPremiumExchangeActivity());
        return requestDto;
    }

    /**
     * 通过购物车获取优惠信息
     * 业务 额外校验
     *
     * @param createOrderVo
     * @param shoppingCartInfoRequestVo
     * @return
     */
    @Override
    protected cn.freemud.base.entity.BaseResponse<ShoppingCartGoodsDto> checkShoppingCartGoods(CreateOrderBaseVo createOrderVo, ShoppingCartInfoRequestVo shoppingCartInfoRequestVo) {
        BaseResponse<ShoppingCartGoodsDto> apportionResponse = super.checkShoppingCartGoods(createOrderVo, shoppingCartInfoRequestVo);
        // 这个是专门的给coco使用的验证券的逻辑
        if (ObjectUtils.equals(ResponseCodeConstant.COCO_RESPONSE_COUPON_ERR_STR, apportionResponse.getCode())) {
            throw new ServiceException(ResponseResult.COCO_COUPON_VALIDATOR_FAIL, apportionResponse.getMessage());
        }
        return apportionResponse;
    }

    /**
     * 拼团逻辑
     *
     * @param createOrderVo
     * @param shoppingCartGoodsDto
     */
    @Override
    protected void collageOrderHandle(CreateOrderBaseVo createOrderVo, ShoppingCartGoodsDto shoppingCartGoodsDto) {
        commonCheckOrderHandle.collageOrderHandle(createOrderVo, shoppingCartGoodsDto);
    }

    /**
     * 校验优惠券
     *
     * @param createOrderVo
     * @param shoppingCartInfoRequestVo
     */
    @Override
    protected void diyCheckCouponCode(CreateOrderBaseVo createOrderVo, ShoppingCartInfoRequestVo shoppingCartInfoRequestVo) {
        commonCheckOrderHandle.diyCheckCouponCode(createOrderVo, shoppingCartInfoRequestVo);
    }


    /**
     * 业务专属 校验
     *
     * @param createOrderBo
     */
    @Override
    public void checkCustomCreateOrderParam(CreateOrderBo createOrderBo) {
        // 查询小程序自提外卖配置信息 校验当前订单类型的下单参数 校验外卖是否满足起送条件
        super.checkOrderByOrderType(createOrderBo);

    }


}
