/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: OrderAffirmReq
 * @Package com.freemud.application.sdk.api.ordercenter.request
 * @Description:
 * @author: ping.wu
 * @date: 2019/10/15 14:23
 * @version V1.0
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package com.freemud.application.sdk.api.ordercenter.request;

import lombok.Data;

import java.math.BigDecimal;

@Data
public class OrderAffirmReq {

    /**
     * 实际支付金额
     */
    private BigDecimal actualPayAmount;
    /**
     * 订单备注
     */
    private String note;
    /**
     * 操作人
     */
    private String operator;
    /**
     * 订单编号
     */
    private String orderCode;
    /**
     * 默认不传则不改变该值，支付状态 1:未支付 2:已支付 3:已退款 4:部分退款
     */
    private Integer payState;
    /**
     * 订单完成时间，若不填写，默认系统生成
     */
    private String receiveTime;

}
