package com.freemud.sdk.api.assortment.order.request.order;

import com.freemud.application.sdk.api.ordercenter.enums.OrderClientType;
import com.freemud.application.sdk.api.ordercenter.enums.OrderType;
import com.freemud.application.sdk.api.ordercenter.request.OrderExtendedReq;
import com.freemud.sdk.api.assortment.order.config.BaseConfig;
import com.freemud.sdk.api.assortment.order.entities.promption.ActivityUpdateStockRequest;
import com.freemud.sdk.api.assortment.order.enums.*;
import lombok.Data;

import java.util.Date;
import java.util.List;

@Data
public class BaseCreateOrderRequest extends BaseConfig {
    /**
     *  爱马哥蛋糕预定
     *  预定单需求, bizType= 7  其他的场景默认传递null
     */
    private Integer bizType;

    /**
     * 商户ID 必填
     */
    private String companyId;
    /**
     * 门店ID
     */
    private String shopId;
    /**
     * 第三方门店
     */
    private String thirdShopId;
    /**
     * 门店名称
     */
    private String shopName;
    /**
     * 门店英文名称
     */
    private String shopNameEn;
    /**
     * 用户ID
     */
    private String userId;
    /**
     * 用户名称
     */
    private String userName;
    /**
     * 收货名姓名
     */
    private String contactsName;
    /**
     * 三方单号
     */
    private String thirdOrderCode;
    /**
     * 用户电话
     */
    private String phone;
    /**
     * 收货地址 非必填
     */
    private String address;
    /**
     * 收货地址经度 非必填
     */
    private String longitude;
    /**
     * 收获地址维度  非必填
     */
    private String latitude;
    /**
     * 老订单类型  1 外卖  4 自提  5 堂食
     */
//    private OrderTypeV1 orderType;

    private OrderType newOrderType;
    /**
     * 订单状态
     */
//    private OldOrderStatus orderStatus;
    /**
     * 支付类型
     */
    private QueryPayType payType;
    /**
     * 支付状态
     */
//    private PayStatus payStatus;
    /**
     * 支付渠道号
     */
    private String payChannel;
    /**
     * 支付渠道名称
     */
    private String payChannelName;

    private OrderClientType orderClient;
    /**
     * 订单来源
     */
    private String source;
    /**
     * 订单来源名称
     */
    private String sourceName;
    /**
     * 期望送达时间
     */
    private Long gmtExpect;
    /**
     * 支付时间
     */
    private Date payTime;

    /**
     * 订单备注
     */
    private String remark;

    /**
     * 实付金额
     */
    private Long amount;

    private Long totalScore;
    //桌号
    private String barCounter;
    /**
     * 商品列表
     */
    private List<CreateOrderProductRequest> products;
    /**
     * 其他结算列表
     */
    private List<CreateOrderAccountRequest> accounts;

    private StoreDeliveryMethod deliveryType;

    public OrderOtherInfo otherInfo;

    private OrderExtendedReq orderExtended;

    //操作人
    private String operator;
    /**
     * 微信、支付宝、APP渠道appid
     */
    private String appId;

    /**
     * 促销活动扣减库存
     */
    public ActivityUpdateStockRequest activityUpdateStockRequest;

    /**
     * 订单渠道
     */
    private String menuType;

    /**
     * 省
     */
    private String province;

    /**
     * 城市
     */
    private String city;

    /**
     * 区
     */
    private String region;

    private Byte payChannelType;

    /**
     * 收货地址Id
     */
    private String receiveId;

    /**
     * 订单特殊类型 1:普通订单 2:拼团订单 3:秒杀订单 4:拼单订单
     */
    private Byte marketingType;

    private Long totalDiscountAmount;

    /**
     * 预计送达时间 调用门店服务计算得出
     */
    private Date estimateDeliveryCompleteTime;

//    @Data
//    public static class DeliveryTypeInfo {
//        /**
//         * 订单类型，自配送self，第三方配送third
//         */
//        private QueryDeliveryType deliveryType;
//    }

    @Data
    public static class OrderOtherInfo {
        /**
         * 流程的 sessionId
         */
        private String sessionId;
        /**
         * 版本号
         */
        private String version;
        /**
         * 小程序授权accessToken 可为空
         */
        private String accessToken;
        /**
         * 小程序授权过期时间
         */
        private String expireDate;
        /**
         * 预计送达时间
         */
        private Integer serviceTime;
        /**
         * 第三方外卖定时推单时间
         */
        private Integer pushOrderTime;
        /**
         * 会员规则ID
         */
        private String ruleId;

        private SendPoint point;

        //门店英文名称
        private String storeNameEn;

        private Integer totalScore;

    }

    @Data
    public static class SendPoint{

        private String activityCode;
        private Date endTime;
        private Integer sendPoint;
        private Integer maxNum;
        private Integer validityDateDays;
        private Boolean storeLevel;
        private Integer isContinueExchange;

    }

    /**
     * 买一赠一选择的商品
     */
    private List<ChooseGood> chooseGoods;

    @Data
    public static class ChooseGood {

        /**
         * 活动类型
         */
        private Integer activeType;

        /**
         * 活动号
         */
        private String activeCode;

        /**
         * 赠送商品id
         */
        private String goodsId;

        /**
         * 赠送商品名称
         */
        private String goodsName;

        /**
         * 赠送商品数量
         */
        private Integer qty;

        /**
         * 可兑换商品券编号
         */
        private String couponCode ;

        /**
         * 商品券兑换数量
         */
        private Integer couponQty;

        /**
         *  是否已选择寄杯
         */
        private Boolean sendCoupon;
    }

}
