package cn.freemud.entities.dto;

import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@NoArgsConstructor
@Data
public class GetMemberListResponseDto {

    private String code;
    private String message;
    private ResultBean data;

    @NoArgsConstructor
    @Data
    public static class ResultBean {

        private List<Member> memberList;
        private Integer totalPages;
        private Integer pageNum;
        private Integer pageSize;
        private Integer totalCount;

        @NoArgsConstructor
        @Data
        public static class Member {
            /**
             * 会员Id
             */
            private String memberId;
            private String mobile;
            private String nickName;
            private String RegisterTime;
            private String ruleName;
            private Integer statusFlag;
            private Integer currentScore;
            private Integer consumeMoney;
            private Integer consumerCount;
            private List<String> labelList;
            private List<Integer> memberPaidList;
        }
    }

}
