package cn.freemud.demo.utils;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: PayApplicationContextWare
 * @Package com.freemud.pay
 * @Description: ApplicationContextAware 的实现，
 * @author: xudong.cai
 * @date: 17/5/18 下午4:12
 * @Copyright: 2017 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Component
public class ApplicationContextWareBean implements ApplicationContextAware {
    private static ApplicationContext context;

    private static String appName;
    @Autowired
    public void setAppName(@Value("${spring.application.name}") String appName) {
        ApplicationContextWareBean.appName = appName;
    }

    public enum profiles {
        TEST("test"), PRO("pro"), DEFAULT("default"), MOCK("mock"), MOBILE_PRO("mobile-pro");
        private String profile;

        public String getProfile() {
            return profile;
        }

        public void setProfile(String profile) {
            this.profile = profile;
        }

        profiles(String profile) {
            this.profile = profile;
        }
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        context = applicationContext;
    }

    public static boolean isTestProfile() {
        String[] activeProfiles = context.getEnvironment().getActiveProfiles();
        if (activeProfiles != null && activeProfiles.length > 0) {
            for (String profile : activeProfiles) {
                if (profiles.TEST.getProfile().equals(profile)) {
                    return true;
                }

            }
        }
        return false;
    }

    public static boolean isProProfile() {
        String[] activeProfiles = context.getEnvironment().getActiveProfiles();
        if (activeProfiles != null && activeProfiles.length > 0) {
            for (String profile : activeProfiles) {
                if (profiles.PRO.getProfile().equals(profile)) {
                    return true;
                }

            }
        }
        return false;
    }

    public static boolean isDevProfile() {
        String[] activeProfiles = context!=null?context.getEnvironment().getActiveProfiles():new String[]{System.getProperty("spring.profiles.active")};
        if (activeProfiles != null && activeProfiles.length > 0) {
            for (String profile : activeProfiles) {
                if (profiles.DEFAULT.getProfile().equals(profile)) {
                    return true;
                }

            }
        }
        return false;
    }

    public static String getAppName() {

        return StringUtils.isEmpty(appName) ? (context!=null?context.getEnvironment().getProperty("spring.application.name"):""):appName;
    }

    public static boolean isQuickDep(){
        return "yes".equals(System.getProperty("quickDep"));
    }

    public static <T> T getBean(Class<T> tClass) {
        return context.getBean(tClass);
    }

    public static <T> T getBean(String var1, Class<T> var2) {
        return context.getBean(var1, var2);
    }

    public static Object getBean(String idOrName) {
        return context.getBean(idOrName);
    }


    public static String getProfile() {
        String[] activeProfiles = context.getEnvironment().getActiveProfiles();
        if (activeProfiles != null && activeProfiles.length > 0) {
            for (String profile : activeProfiles) {
                if (profiles.PRO.getProfile().equals(profile)) {
                    return profiles.PRO.getProfile();
                } else if (profiles.TEST.getProfile().equals(profile)) {
                    return profiles.TEST.getProfile();
                } else if (profiles.MOCK.getProfile().equals(profile)) {
                    return profiles.MOCK.getProfile();
                }

            }
        }
        return profiles.TEST.getProfile();//默认环境返回Test
    }

}
