package cn.freemud.demo.service;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.demo.entities.*;
import cn.freemud.demo.entities.bo.goods.add.BaseAddGoodsBO;

public interface AddGoodsService {

    /**
     *
     * 检验客制化的参数
     * @param baseRequestDTO
     * @return
     */
    default BaseResponse checkCustomParams(BaseAddGoodsBO baseRequestDTO) {
        return ResponseBuilder.success();
    }


    /**
     * 获取购物车信息
     * @param baseRequestDTO
     * @return
     */
    default CheckBussinessRulesBO getShoppingCartInfo(BaseAddGoodsBO baseRequestDTO) {
        return new CheckBussinessRulesBO();
    }

    /**
     * 进行客制化的业务校验
     * @param baseRequestDTO
     * @return
     */
    default AddGoodsToShoppingCartBO checkCustomBusinessRules(BaseAddGoodsBO baseRequestDTO, CheckBussinessRulesBO checkBussinessRulesBO, AddGoodsToShoppingCartBO addGoodsToShoppingCartBO) {
        return null;
    }



    /**
     * 购物车赋值
     * @param baseRequestDTO
     * @return
     */
    default CalCostBO customAddGoodsToShoppingCart(BaseAddGoodsBO baseRequestDTO, AddGoodsToShoppingCartBO addGoodsToShoppingCartBO, CalCostBO customCalCostBO) {
        return new CalCostBO();
    }



    /**
     * 进行客制化的计算费用
     * @param baseRequestDTO
     * @return
     */
    default SetMessageBO calCustomCost(BaseAddGoodsBO baseRequestDTO, CalCostBO calCostBO, SetMessageBO commonSetMessageBO) {
        return null;
    }

    /**
     * 进行客制化的计算费用
     * @param baseRequestDTO
     * @return
     */
    default AddGoodsShoppingCartBO setCustomMessage(BaseAddGoodsBO baseRequestDTO, SetMessageBO setMessageBO, AddGoodsShoppingCartBO commonAddGoodsShoppingCartBO) {
        return null;
    }

}
