package cn.freemud.demo.service;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.demo.constant.ResponseConstant;
import cn.freemud.demo.entities.*;
import cn.freemud.demo.entities.bo.goods.GetProductBO;
import cn.freemud.demo.entities.bo.goods.add.BaseAddGoodsBO;
import cn.freemud.demo.manager.product.ProductManager;
import cn.freemud.demo.manager.customer.CustomerManager;
import cn.freemud.enums.ResponseResult;
import cn.freemud.interceptor.ServiceException;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractAddGoodsService implements AddGoodsService {

    @Autowired
    private CustomerManager customerManager;

    @Autowired
    private ProductManager productManager;


    /**
     * 加车的流程
     *
     * @return
     */
    public final AddGoodsShoppingCartBO addGoods(BaseAddGoodsBO addGoodsBO) {
        // 基本参数校验
        this.checkParams(addGoodsBO);

        // 获取购物车和加车商品信息
        CheckBussinessRulesBO checkBussinessRulesBO = this.getShoppingCartInfo(addGoodsBO);

        // 业务校验,例如商品数量库存之类的信息
        AddGoodsToShoppingCartBO addGoodsToShoppingCartBO = this.checkBusinessRules(addGoodsBO, checkBussinessRulesBO);

        // 添加商品到购物车
        CalCostBO calCostBO = this.addGoodsToShoppingCart(addGoodsBO, addGoodsToShoppingCartBO);

        // 计算费用,例如配送费
        SetMessageBO setMessageBO = this.calCost(addGoodsBO, calCostBO);

        // 提示语设置,例如满减信息
        AddGoodsShoppingCartBO addGoodsShoppingCartBO = this.setMessage(addGoodsBO, setMessageBO);

        return addGoodsShoppingCartBO;
    }

    /**
     * 计算不在促销计算范围里的费用
     * @param addGoodsBO
     * @return
     */
    public final SetMessageBO calCost(BaseAddGoodsBO addGoodsBO, CalCostBO calCostBO) {
        SetMessageBO commonSetMessageBO = this.calCommCost(addGoodsBO, calCostBO);

        SetMessageBO customSetMessageBO = this.calCustomCost(addGoodsBO, calCostBO, commonSetMessageBO);

        return customSetMessageBO;
    }

    /**
     * 设置提示语
     * @param addGoodsBO
     * @return
     */
    public final AddGoodsShoppingCartBO setMessage(BaseAddGoodsBO addGoodsBO, SetMessageBO setMessageBO) {
        AddGoodsShoppingCartBO commonAddGoodsShoppingCartBO = this.setCommMessage(addGoodsBO, setMessageBO);

        AddGoodsShoppingCartBO customAddGoodsShoppingCartBO = this.setCustomMessage(addGoodsBO, setMessageBO, commonAddGoodsShoppingCartBO);

        return customAddGoodsShoppingCartBO;
    }


    /**
     * 请求基本参数校验
     * @return
     */
    public final BaseResponse checkParams(BaseAddGoodsBO baseRequestDTO) {
        BaseResponse commonBaseResponse = this.checkCommParams(baseRequestDTO);
        if (!ResponseConstant.RESPONSE_SUCCESS_STR.equals(commonBaseResponse.getCode())){
            return commonBaseResponse;
        }
        BaseResponse customBaseResponse = this.checkCustomParams(baseRequestDTO);
        if (!ResponseConstant.RESPONSE_SUCCESS_STR.equals(customBaseResponse.getCode())){
            return customBaseResponse;
        }
        return ResponseBuilder.success();
    }

    /**
     * 1. 获取加车的商品信息
     * 2. 获取购物车的商品信息
     *
     * @return
     */
    public final CheckBussinessRulesBO getShoppingCartInfo(BaseAddGoodsBO baseRequestBO) {
        CheckBussinessRulesBO bo = new CheckBussinessRulesBO();
        String userId = customerManager.getUserId(baseRequestBO.getSessionId(), baseRequestBO.getManagerService().getCustomerService());
        baseRequestBO.setUserId(userId);


        GetProductBO getProductBO = convert2ProductBO(baseRequestBO);
        productManager.getProductsInfo(getProductBO, baseRequestBO.getManagerService().getProductService());





        return bo;
    }

    private GetProductBO convert2ProductBO(BaseAddGoodsBO baseRequestBO) {
        GetProductBO getProductBO = new GetProductBO();
        getProductBO.setMenuType(baseRequestBO.getMenuType());
        getProductBO.setPartnerId(baseRequestBO.getPartnerId());
        getProductBO.setSkuid(baseRequestBO.getSkuId());
        getProductBO.setSpuid(baseRequestBO.getSpuId());
        getProductBO.setStoreId(baseRequestBO.getShopId());
        return getProductBO;
    }

    /**
     * 具体业务逻辑校验, 例如商品数量,库存等校验
     *
     * @return
     */
    public final AddGoodsToShoppingCartBO checkBusinessRules(BaseAddGoodsBO baseRequestDTO, CheckBussinessRulesBO checkBussinessRulesBO) {
        AddGoodsToShoppingCartBO commAddGoodsToShoppingCartBO = this.checkCommBusinessRules(baseRequestDTO, checkBussinessRulesBO);
        AddGoodsToShoppingCartBO customAddGoodsToShoppingCartBO = this.checkCustomBusinessRules(baseRequestDTO, checkBussinessRulesBO, commAddGoodsToShoppingCartBO);
        return customAddGoodsToShoppingCartBO;
    }


    /**
     * 添加商品到购物车,并重新设置购物车
     *
     * @return
     */
    public final CalCostBO addGoodsToShoppingCart(BaseAddGoodsBO baseRequestDTO, AddGoodsToShoppingCartBO addGoodsToShoppingCartBO) {

        CalCostBO commCalCostBO = this.commAddGoodsToShoppingCart(baseRequestDTO, addGoodsToShoppingCartBO);

        CalCostBO customCalCostBO = this.customAddGoodsToShoppingCart(baseRequestDTO, addGoodsToShoppingCartBO, commCalCostBO);

        this.updateShoppingCartCache(customCalCostBO);

        return commCalCostBO;
    }


    private BaseResponse checkCommParams(BaseAddGoodsBO baseRequestDTO) {

        if (StringUtils.isEmpty(baseRequestDTO.getShopId())){
            throw new ServiceException(ResponseResult.SHOPPING_CART_SHOP_ID_NOT_EMPTY);
        }

        return ResponseBuilder.success();
    }

    private AddGoodsToShoppingCartBO checkCommBusinessRules(BaseAddGoodsBO baseRequestDTO, CheckBussinessRulesBO checkBussinessRulesBO) {
        return null;
    }

    private CalCostBO commAddGoodsToShoppingCart(BaseAddGoodsBO baseRequestDTO, AddGoodsToShoppingCartBO addGoodsToShoppingCartBO) {
        return null;
    }

    public final void updateShoppingCartCache(CalCostBO calCostBO) {
        return ;
    }

    private SetMessageBO calCommCost(BaseAddGoodsBO baseRequestDTO, CalCostBO calCostBO) {
        return null;
    }

    private AddGoodsShoppingCartBO setCommMessage(BaseAddGoodsBO baseRequestDTO, SetMessageBO setMessageBO) {
        return null;
    }

}
