package cn.freemud.demo.factory;

import cn.freemud.demo.entities.bo.goods.add.BaseAddGoodsBO;
import cn.freemud.demo.enums.BizTypeEnum;
import cn.freemud.demo.service.AbstractAddGoodsService;
import cn.freemud.demo.service.MCoffeeAddGoodsService;
import cn.freemud.demo.service.PlatformAddGoodsService;
import cn.freemud.demo.utils.ApplicationContextWareBean;
import org.springframework.beans.factory.annotation.Autowired;

public class ServiceFactory {

    public static AbstractAddGoodsService createAddGoodsServiceInstance(String bizType) {
        AbstractAddGoodsService abstractAddGoodsService;
        if (BizTypeEnum.MCOFFEE.getCode().equals(bizType)) {
            abstractAddGoodsService = ApplicationContextWareBean.getBean(MCoffeeAddGoodsService.class);
        } else {
            abstractAddGoodsService = ApplicationContextWareBean.getBean(PlatformAddGoodsService.class);
        }
        return abstractAddGoodsService;
    }

}
