/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: StoreItemClient
 * @Package cn.freemud.service.thirdparty
 * @Description:
 * @author: liming.guo
 * @date: 2018/5/16 9:39
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.service.thirdparty;

import cn.freemud.aop.IgnoreFeignLogAnnotation;
import cn.freemud.constant.ResponseCodeConstant;
import cn.freemud.constant.ResponseCodeKeyConstant;
import cn.freemud.entities.dto.*;
import com.freemud.application.sdk.api.productcenter.request.product.valid.ValidateShopProductRequest;
import com.freemud.application.sdk.api.productcenter.response.ProductResponseDTO;
import com.freemud.application.sdk.api.productcenter.response.valid.ValiadShopProductResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@FeignClient(value = "PRODUCTSERVICE",url="${saas.storeitemclient.feign.url}")
@RequestMapping(produces = {"application/json;charset=UTF-8"})
public interface StoreItemClient {


    // TODO: 21-3-31 和 PRODUCTSERVICE　待合并

    /**
     * 获取门店特定时间段菜单分类
     */
    @PostMapping(value = "/Menu/GetMenu")
    GetMenuResponseDto getMenuCategory(@RequestBody GetMenuCategoryInfoDto getMenuCategoryInfoDto);

    /**
     * 根据spu或单品ID查询菜单
     * 根据商品id查询门店特定时间段菜单
     */
    @PostMapping(value = "/Menu/GetMenuByIds")
    GetMenuByIdsResponseDto getMenuCategoryByIds(@RequestBody GetMenuCategoryByIdsDto getMenuCategoryByIdsDto);

    /**
     * 获取商品的详细信息
     */
    @PostMapping("/Shop/ListProductInfoByIdList")

    @IgnoreFeignLogAnnotation(excludeStatusCodes = {ResponseCodeConstant.RESPONSE_SUCCESS_STR},statusCodeFieldName= ResponseCodeKeyConstant.ERR_CODE,messageFieldName=ResponseCodeKeyConstant.MEG)

    ProductInfosDto listProductInfos(@RequestBody GetProductInfoDto getProductInfoDto);



    /**
     * 根据skuid查询spu信息
     * @return
     */
    @PostMapping("/Product/GetSpectionProductBySkuId")
    ProductListDto getSpuIdsBySkuIds(@RequestBody GetSpuIdsBySkuIdsDto requestDto);

    /**
     * 校验商品可用性
     */
    @PostMapping("Shop/ValidateShopProduct")
    ProductResponseDTO<ValiadShopProductResponse> validateShopProduct(@RequestBody ValidateShopProductRequest request);

    /**
     * 校验商品在当前门店是否可售
     */
    @PostMapping("/Shop/validateShopContainProduct")
    ValidateProductInfosDto validateShopContainProduct(@RequestBody GetValidateProductInfoDto getProductInfoDto);
}
