package cn.freemud.enums;

import com.google.common.collect.Lists;

import java.util.List;

public enum PayEbCodeYFEnum {
    PAY_EB_CODE_YF_ENUM_10210("10210","优赋小程序支付10210"),
    PAY_EB_CODE_YF_ENUM_10204("10204","优赋小程序支付10204"),
    PAY_EB_CODE_YF_ENUM_10214("10214","优赋小程序支付10214"),
    PAY_EB_CODE_YF_ENUM_10215("10215","优赋小程序支付10215");
    private String code;
    private String message;

    PayEbCodeYFEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public static List<String> getAllCodes() {
        List<String> list = Lists.newArrayList();
        for (PayEbCodeYFEnum payEbCodeYFEnum : values()) {
            list.add(payEbCodeYFEnum.getCode());
        }
        return list;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return message;
    }

    public void setDesc(String desc) {
        this.message = message;
    }
}
