/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: CartGoods
 * @Package cn.freemud.entities.vo
 * @Description:
 * @author: song.cai
 * @date: 2018/12/28 16:45
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */

package com.freemud.sdk.api.assortment.shoppingcart.domain;

import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;
import java.util.Objects;
import java.util.UUID;

@Data
public class CartGoods {
    /**
     * 购物车一行的Id（后台生成）
     */
    private String cartGoodsUid = UUID.randomUUID().toString();

    /**
     * 加车时间
     */
    private Long addCartTime;

    /**
     * 单规格spuId,多规格skuId
     */
    private String goodsId;

    /**
     * 购买人的的名称
     */
    private String userName;

    /**
     * 购买人的的userId
     */
    private String userId;

    /**
     * 购买人的的openId
     */
    private String openId;

    /**
     * 购买人的的头像
     */
    private String photoUrl;

    /**
     * 1.正常商品，2.商品券，3.套餐商品
     */
    private Integer goodsType;
    /**
     * 1:称重菜
     */
    private boolean weightType;
    /**
     * 重量
     */
    private Double weight;
    /**
     * 单位
     */
    private String unit;

    /**
     * 商品券code
     */
    private String couponCode;
    /**
     * 是否是月享卡商品
     */
    private int isMonthCard;
    /**
     * 是否为种子券商品 1:是；0:否
     */
    private int isSeedCouponGoods;
    /**
     * 月享卡信息
     */
    private MonthCardVo monthCardInfo;
    /**
     * 商品券名称
     */
    private String couponName;

    private String spuId;
    private String skuId;
    /**
     * 所有属性attributeId的拼接
     */
    private String specProductId;
    /**
     * 购物车一行商品的原单价
     */
    private Long originalPrice;
    /**
     * 购物车一行商品的现单价
     */
    private Long finalPrice;

    /**
     * 购物车一行商品的包装费
     */
    private Long packPrice;

    /**
     * 购物车一行商品的原总价
     */
    private Long originalAmount;
    //购物车一行小料商品的原总价
    private Long originalMaterialAmount;
    /**
     * 购物车一行商品的现总价
     */
    private Long amount;
    /**
     * 购物车加料商品总价
     */
    private Long materialAmount;
    /**
     * 购物车一行商品的数量
     */
    private Integer qty;
    /**
     * 购物车一行商品的名称
     */
    private String name;

    /**
     * 商品的spuName
     */
    private String spuName;

    /**
     * 商品的skuName
     */
    private String skuName;

    /**
     * 购物车一行商品的副名称
     */
    private String subName;
    /**
     * 商品图片URL
     */
    private String pic;
    /**
     * 配料或属性
     */
    private List<CartGoodsExtra> extra;

    /**
     * 麦咖啡定制属性
     */
    private List<SpecialExtra> specialExtra;

    /**
     * 创建时间（mili）
     */
    private long createTimeMili = System.currentTimeMillis();
    /**
     * 1.5.5版本添加
     * 商品参与活动类型(61:买一赠一)
     */
    private Integer activityType;
    /**
     * 1.6.0 版本增加  节点ID
     */
    private String nodeId;
    /**
     * 1.6.0 版本增加 分类名
     */
    private String categoryName;
    /**
     * 统计分类编号
     */
    private String classificationId;
    /**
     * 统计分类名称
     */
    private String classificationName;
    /**
     * 是否限制库存
     * 用于创建订单时，是否扣减库存
     */
    private boolean isStockLimit;
    /**
     * 第三方商品编码
     */
    private String customerCode;
    /**
     * 商品起售份数
     * 无起售份数默认值1
     */
    private Integer riseSell;
    /**
     * 折扣比例
     * 例如8折为80
     */
    private Integer memberDiscount;

    /**
     * 税率
     */
    private Double tax;

    /**
     * 税率代码
     */
    private String taxId;

    /**
     * 套餐固定商品
     */
    private List<ComboxGoods> productComboList;
    /**
     * 套餐可选商品
     */
    private List<ComboxGoods> productGroupList;

    /**
     * 商品加料
     */
    private List<MaterialGoods> productMaterialList;

    @Data
    public final static class CartGoodsExtra {
        /**
         * 属性Id
         */
        private String attributeId;
        /**
         * 属性名
         */
        private String attributeName;
    }

    @Data
    public final static class SpecialExtra {
        /**
         * 属性Id
         */
        private String attributeId;
        /**
         * 属性名
         */
        private String attributeName;

        /**
         * 麦咖啡特定属性入机code
         */
        private String specialCode;
    }

    @Data
    @NoArgsConstructor
    public class MonthCardVo {
        /**
         * 卡号
         */
        private String cardNo;
        /**
         * 券号
         */
        private String cardCode;
        /**
         * 月享卡类型：1.月享卡(单商品购买)；2.月享卡(多商品购买)；3.普通月卡
         */
        private Integer type;
    }

    @Data
    public final static class ComboxGoods{
        /**
         * 单规格spuId,多规格skuId
         */
        private String goodsId;
        private String spuId;
        private String skuId;
        private String skuName;
        /**
         * 所有属性attributeId的拼接
         */
        private String specProductId;
        /**
         * 购物车一行商品的原单机
         */
        private Long originalPrice;
        /**
         * 购物车一行商品的现单价
         */
        private Long finalPrice;

        /**
         * 购物车一行商品的包装费
         */
        private Long packPrice;

        /**
         * 购物车一行商品的原价
         */
        private Long originalAmount;

        /**
         * 购物车一行商品的现价
         */
        private Long amount;

        /**
         * 加料商品商品价格
         */
        private Long materialAmount;
        /**
         * 购物车一行商品的数量
         */
        private Integer qty;
        /**
         * 购物车一行商品的名称
         */
        private String name;

        /**
         * 商品的spuName
         */
        private String spuName;
        /**
         * 购物车一行商品的副名称
         */
        private String subName;
        /**
         * 商品图片URL
         */
        private String pic;
        /**
         * 第三方商品编码
         */
        private String customerCode;
        /**
         * 1:称重菜
         */
        private boolean weightType;
        /**
         * 重量
         */
        private Double weight;
        /**
         * 单位
         */
        private String unit;
        /**
         * 商品组Id
         */
        private Long productGroupId;
        /**
         * 配料或属性
         */
        private List<CartGoodsExtra> extra;

        /**
         * 麦咖啡定制属性
         */
        private List<SpecialExtra> specialExtra;

        /**
         * 麦咖啡套餐商品加料
         */
        private List<MaterialGoods> productMaterialList;

        /**
         * 税率
         */
        private Double tax;

        /**
         * 税率代码
         */
        private String taxId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o)
            return true;
        if (o == null || getClass() != o.getClass())
            return false;
        CartGoods cartGoods = (CartGoods) o;
        return Objects.equals(goodsId, cartGoods.goodsId) &&
                Objects.equals(goodsType, cartGoods.goodsType) &&
                Objects.equals(spuId, cartGoods.spuId) &&
                Objects.equals(skuId, cartGoods.skuId) &&
                Objects.equals(specProductId, cartGoods.specProductId) &&
                Objects.equals(originalPrice, cartGoods.originalPrice) &&
                Objects.equals(packPrice, cartGoods.packPrice) &&
                Objects.equals(name, cartGoods.name) &&
                Objects.equals(subName, cartGoods.subName) &&
                Objects.equals(pic, cartGoods.pic) &&
                Objects.equals(extra, cartGoods.extra);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), goodsId, goodsType, spuId, skuId, specProductId, originalPrice, packPrice, name, subName, pic, extra);
    }

    @Data
    @NoArgsConstructor
    public static class MaterialGoods {
        /**
         * 加料Id
         */
        private String spuId;
        /**
         * 加料名称
         */
        private String spuName;
        /**
         * 购物车一行商品的现单价
         */
        private Long finalPrice;

        /**
         * 购物车一行商品的原单价
         */
        private Long originalAmount;
        private Long originalPrice;

        /**
         * 购物车一行商品的总现价
         */
        private Long amount;
        /**
         * 麦咖啡入机键位
         */
        private String customerCode;
    }
}
