/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: OrderExtInfoDto
 * @Package com.freemud.application.sdk.api.ordercenter.request
 * @Description:
 * @author: ping.wu
 * @date: 2019/4/2 20:21
 * @version V1.0
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package com.freemud.application.sdk.api.ordercenter.request;

import lombok.Data;

import java.util.Date;


@Data
public class OrderExtInfoDto {

    private  String prepayId;

    /**
     * 支付宝小程序订单特定模板消息需要
     */
    private  String formId;

    private String accessToken;
    /**
     * 到期时间
     */
    private String expireDate;
    /**
     * 外卖开始时间
     */
    private String deliveryHoursDayStart;
    /**
     * 外卖结束时间
     */
    private String deliveryHoursDayEnd;


    private String openid;

    private String appid;

    private String appsecret;
    /**
     * 订单支付时间
     */
    private String payDate;
    /**
     * 第三方流水号
     */
    private String payTransId;
    /**
     * sessionId
     */
    private String sessionId;
    /**
     * 预计送达时间
     */
    private Integer serviceTime;
    /**
     * 第三方外卖定时推单时间
     */
    private Integer pushOrderTime;
    /**
     *  版本号
     */
    private String version;

    private String trackingNo;
    /**
     * 会员规则ID
     */
    private String ruleId;
    /**
     * 预支付 transId
     */
    private String prePayTransId;

    private String memberLevel;

    private boolean paidMember;

    /**
     * 微信上报异常补推使用
     */
    private String sessionKey;

    /**
     * 来源appId
     */
    private String fromAppId;

    private String fmId;
    /**
     * 创建预支付订单userId
     */
    private String prePayUserId;

    /**
     * 用户手机号
     */
    private String phone;
    /**
     * 平台支付订单号(微信订单号)
     */
    private String paid_no;
    /**
     * 渠道方流水号 （比如扫呗，易宝等） 新支付服务做中转使用
     */
    private String endTransId;
    /**
     * 第三方支付商户号 新支付服务做中转使用
     */
    private String platformMchId;
    /**
     * 扫呗商户号 新支付服务做中转使用
     */
    private String terminalId;

    /**
     * 停车场ID
     */
    private String parkingAreaId;

    private String parkingAreaName;
    /**
     * 车牌号
     */
    private String carNumber;
    /**
     * 入场时间
     */
    private String inTime;
    /**
     * 出场时间
     */
    private String outTime;
    /**
     * 打开小程序的场景值。
     */
    private String scene;

    /**
     * 支付渠道编号(参考支付组payment_platform)
     */
    private String payCode;

    /**
     * 停车场订单手机号
     */
    private String mobile;

    /**
     * 是否需要餐具，1 需要 0不需要
     */
    private Integer needTableware;

    /**
     * 是否需要开发票，1 需要 0不需要
     */
    private Integer needInvoice;

    /**
     * 发票抬头
     */
    private String invoiceTitle;

    /**
     * 麦咖啡会员号
     */
    private String thirdPartyMemberId;

    private String sendPointActivityCode;
    private String sendPointEndTime;
    private Integer sendPointSendPoint;
    private Integer sendPointMaxNum;
    private Integer sendPointValidityDateDays;
    private Boolean sendPointStoreLevel;

    /**
     * 唤起预支付设备号
     */
    private String stationId;

    /**
     * 线下订单储值卡支付金额
     */
    private Integer svcAmount;

    private String svcCardCode;

    /**
     * 操作类型
     */
    private String autoReceiveTime;


}
