package cn.freemud.manager;


import cn.freemud.entities.db.OpenPlatformWxappPayEbcode;
import cn.freemud.manager.dao.OpenPlatformWxappPayEbCodeDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.List;

@Component
public class OpenPlatformWxappPayEbCodeManager {

    @Autowired
    private OpenPlatformWxappPayEbCodeDao openPlatformWxappPayEbCodeDao;

    public int addOpenPlatformWxappPayEbCode(OpenPlatformWxappPayEbcode openPlatformWxappPayEbcode) {
        openPlatformWxappPayEbcode.setGmtCreated(new Date());
        openPlatformWxappPayEbcode.setGmtModified(new Date());
        return openPlatformWxappPayEbCodeDao.insert(openPlatformWxappPayEbcode);
    }

    public int update(OpenPlatformWxappPayEbcode openPlatformWxappPayEbcode) {
        openPlatformWxappPayEbcode.setGmtModified(new Date());
        return openPlatformWxappPayEbCodeDao.updateByPrimaryKeySelective(openPlatformWxappPayEbcode);
    }
    public int deleteByWxAppId(String wxAppId) {
        OpenPlatformWxappPayEbcode openPlatformWxappPayEbcode=new OpenPlatformWxappPayEbcode();
        openPlatformWxappPayEbcode.setWxAppid(wxAppId);
        return openPlatformWxappPayEbCodeDao.delete(openPlatformWxappPayEbcode);
    }
    public OpenPlatformWxappPayEbcode findByWxappId(String wxAppid) {
        OpenPlatformWxappPayEbcode openPlatformWxappPayEbcode = new OpenPlatformWxappPayEbcode();
        openPlatformWxappPayEbcode.setWxAppid(wxAppid);
        return openPlatformWxappPayEbCodeDao.selectOne(openPlatformWxappPayEbcode);
    }

    public List<OpenPlatformWxappPayEbcode> findByPartnerId(String partnerId) {
        OpenPlatformWxappPayEbcode openPlatformWxappPayEbcode = new OpenPlatformWxappPayEbcode();
        openPlatformWxappPayEbcode.setPartnerId(partnerId);
        return openPlatformWxappPayEbCodeDao.select(openPlatformWxappPayEbcode);
    }
}
