package cn.freemud.entities.dto.activity;

import lombok.Builder;
import lombok.Data;

import java.util.List;
import java.util.Objects;

@Data
public class ShareDiscountActivityDto {

    /**
     * 商品spuId
     */
    private String spuId;
    /**
     * 请求的商品 skuId 如果是单品，spuId
     */
    private String goodsId;
    /**
     * 商品购物车原始价格
     */
    private Long originalPrice;
    /**
     * 商品的数量
     */
    private int goodsQuantity;
    /**
     * 是否包含商品券
     */
    private Boolean hasProductCoupon = false;
    /**
     * 1.5.5版本添加
     * 商品参与活动类型(61:买一赠一)
     */
    private Integer activityType;
    @Override
    public boolean equals(Object o) {
        if (this == o)
            return true;
        if (o == null || getClass() != o.getClass())
            return false;
        ShareDiscountActivityDto that = (ShareDiscountActivityDto) o;
        return Objects.equals(spuId, that.spuId) &&
                Objects.equals(goodsId, that.goodsId) &&
                Objects.equals(originalPrice, that.originalPrice);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), spuId, goodsId, originalPrice);
    }

    /**
     * 均摊详情
     */
    List<ApportionGood> apportionGoods;

    @Data
    @Builder
    public static class ApportionGood {

        /**
         * goodsId 商品ID
         */
        private String goodsId;
        /**
         * 商品数量
         */
        private Integer goodsQuantity;
        /**
         * 优惠后剩余支付平均价格  （originalPrice*goodsQuantity - apportionAmount*goodsQuantity）/goodsQuantity
         */
        private Long nowPrice;
        /**
         * 原价
         */
        private Long originalPrice;
        /**
         * 单个优惠金额
         */
        private Long apportionAmount = 0L;


        private List<ApportionDetail> apportionDetails;

        @Data
        public static class ApportionDetail {

            /**
             * 活动code,如果是商品券，优惠券，放券code
             */
            private String activityCode;
            /**
             * 活动类型  ActivityTypeEnum 枚举，不能为空
             */
            private Integer activityType;
            /**
             * 活动名称，如果是商品券，优惠券，放券名称
             */
            private String activityName;
            /**
             * 特价价格 比如限时特价价格
             */
            private Long goodsNowPrice = 0L;
            /**
             * 折扣比率 百分比，非必传  有折扣活动
             */
            private Long activityRebate = 0L;
            /**
             * 促销类型  交易类促销  商品类促销  ApportionType
             */
            private Integer apportionType;
            /**
             * 实际享受数量
             */
            private Integer goodsQuantity;
            /**
             * 活动均摊金额 单个商品
             */
            private Long activityApportionAmount = 0L;


        }

    }


}
