package cn.freemud.entities.db;

import lombok.Data;

import javax.persistence.*;
import java.util.Date;

@Data
@Table(name = "open_platform_partner_merchant")
public class OpenPlatformPartnerMerchant {
    /**
     * 主键ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    /**
     * 品牌id
     */
    @Column(name = "partner_id")
    private String partnerId;

    /**
     * 申请状态（0:申请成功，1:审核失败，3:微信申请中）
     */
    @Column(name = "status")
    private String status;

    /**
     * 第三方支付渠道
     */
    @Column(name = "platform")
    private String platform;

    /**
     * 微信支付商户号
     */
    @Column(name = "mch_id")
    private String mchId;

    /**
     * 联系人姓名
     */
    @Column(name = "user_name")
    private String userName;

    /**
     * 手机号
     */
    @Column(name = "user_mobile")
    private String userMobile;

    /**
     * 常用邮箱
     */
    @Column(name = "user_email")
    private String userEmail;

    /**
     * 主体名称
     */
    @Column(name = "company_name")
    private String companyName;

    /**
     * 商户简称
     */
    @Column(name = "mch_name")
    private String mchName;

    /**
     * 门店地址
     */
    @Column(name = "mch_address")
    private String mchAddress;

    /**
     * 特殊资质（图片url）
     */
    @Column(name = "special_aptitude")
    private String specialAptitude;

    /**
     * 客服电话
     */
    @Column(name = "mch_phone")
    private String mchPhone;

    /**
     * 营业执照照片(url)
     */
    @Column(name = "license_picture")
    private String licensePicture;

    /**
     * 经办人身份证(url)
     */
    @Column(name = "id_card_no")
    private String idCardNo;

    /**
     * 账号类型
     */
    @Column(name = "account_type")
    private String accountType;

    /**
     * 银行名称
     */
    @Column(name = "account_name")
    private String accountName;

    /**
     * 银行开户行
     */
    @Column(name = "account_address")
    private String accountAddress;

    /**
     * 开户城市（省、市、区）
     */
    @Column(name = "account_city")
    private String accountCity;

    /**
     * 开户支行
     */
    @Column(name = "account_branch")
    private String accountBranch;

    /**
     * 银行账号
     */
    @Column(name = "account_no")
    private String accountNo;

    /**
     * 创建时间
     */
    @Column(name = "gmt_created")
    private Date gmtCreated;

    /**
     * 修改时间
     */
    @Column(name = "gmt_modified")
    private Date gmtModified;

    /**
     * 失败原因
     */
    @Column(name = "remark")
    private String remark;

    /**
     * 商户最后一次提交申请时间
     */
    @Column(name = "latest_submit_time")
    private Date latestSubmitTime;

    /**
     * 申请微信支付商户号提交人昵称
     */
    @Column(name = "operator")
    private String operator;

    /**
     * BOS运营人员审核时间
     */
    @Column(name = "bos_auditing_time")
    private Date bosAuditingTime;
}