package cn.freemud.service.impl.mcoffee.entity;

import lombok.Data;
import org.hibernate.validator.constraints.NotEmpty;

import javax.validation.constraints.NotBlank;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: CopyShoppingCartRequestVo
 * @Package cn.freemud.service.impl.mcoffee.entity
 * @Description:
 * @author: ping1.wu
 * @date: 2020/8/10 17:13
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Data
public class CopyShoppingCartRequestVo {

    @NotBlank(message = "sessionId不能为空")
    private String sessionId;
    /**
     * 商户Id
     */
    @NotBlank(message = "partnerId不能为空")
    private String partnerId;

    /**
     * 微信appId
     */
    @NotBlank(message = "appId不能为空")
    private String appId;

    /**
     * 门店Id
     */
//    @NotEmpty(message = "shopId不能为空")
    private String shopId;

    /**
     * 订单号
     */
    @NotBlank(message = "orderId不能为空")
    private String orderId;

    /**
     * 操作类型 ShoppingCartOperationType　枚举
     * 校验通过直接返回购物车商品数据
     */
    private Integer operationType;

}
