package cn.freemud.service.impl.calculate.promotion;

import cn.freemud.entities.dto.ActivityResponseDto;
import cn.freemud.entities.dto.BenefitBeanDto;
import cn.freemud.entities.dto.activity.ActivityQueryDto;
import cn.freemud.entities.dto.activity.ActivityQueryResponseDto;
import cn.freemud.entities.dto.calculate.CalculationDiscountResult;
import cn.freemud.entities.dto.calculate.Discount;
import cn.freemud.entities.vo.ShoppingCartGoodsResponseVo;
import cn.freemud.enums.ActivityTypeEnum;
import cn.freemud.service.ActivityService;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.DecimalFormat;
import java.util.LinkedList;
import java.util.List;

import static cn.freemud.constant.ApplicationConstant.*;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: cn.freemud.service.impl.calculate.promotion DelivierySharingService
 * @Description: 满额减配送费用
 * @author: family
 * @date: 2020/9/9
 * @Copyright: www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Service
public class DeliverySharingService {

    @Autowired
    private ActivityService activityService;


    /**
     *  老算价有相同逻辑  别再踩坑了
     * @set cn.freemud.service.impl.ShoppingCartNewServiceImpl  line 1786
     * @param discountResult
     * @param activityQueryDto
     * @param shoppingCartGoodsResponseVo
     * @param deliveryAmount
     */
    public void deliveryResponse(CalculationDiscountResult discountResult
            , ActivityQueryDto activityQueryDto
            , ShoppingCartGoodsResponseVo shoppingCartGoodsResponseVo
            , Long deliveryAmount) {

        DecimalFormat df = new DecimalFormat("###.##");
        List<ActivityTypeEnum> activityTypeEnums = new LinkedList<>();
        activityTypeEnums.add(ActivityTypeEnum.TYPE_14);

        ActivityQueryResponseDto activityQueryResponseDto = activityService.queryActivityByType(activityQueryDto, activityTypeEnums, null);
        ActivityResponseDto activityResponse =null;
        BenefitBeanDto beanDto=null;
        if (activityQueryResponseDto != null &&activityQueryResponseDto.getResult()!=null && activityQueryResponseDto.getResult().size()>0) {
            activityResponse = activityQueryResponseDto.getResult().get(0);
            shoppingCartGoodsResponseVo.setDiscountDeliveryActivityCode(activityResponse.getActivityCode());
            beanDto=activityResponse.getBenefits().get(0);
        }

        Discount discount=null;
        if (discountResult != null && CollectionUtils.isNotEmpty(discountResult.getDiscounts())) {
            discount = discountResult.getDiscounts().stream().filter((d) -> ActivityTypeEnum.TYPE_14.getCode().equals(d.getType())).findFirst().orElse(null);
        }
        if(discount!=null) {
            if(beanDto!=null &&beanDto.getBenefitType() == 1) {
                String desc = DELIVERY_DISCOUNT_DESC2;
                shoppingCartGoodsResponseVo.setDeliveryDiscountDesc(String.format(desc, df.format(beanDto.getThresholdAmount().doubleValue() /100) ));
            }
            else {
                String desc = DELIVERY_DISCOUNT_DESC1;
                shoppingCartGoodsResponseVo.setDeliveryDiscountDesc(String.format(desc, df.format(beanDto.getThresholdAmount().doubleValue() /100) ,df.format(beanDto.getDiscountAmount().doubleValue() / 100)));
            }
            boolean isType34 = verifyActivity(discountResult);
            if (isType34) {
                String desc = shoppingCartGoodsResponseVo.getDeliveryDiscountDesc();
                shoppingCartGoodsResponseVo.setDeliveryDiscountDesc(desc+ ",并且"+ DELIVERY_DISCOUNT_DESC4);
                // 证明使用了配送券 又有活动优惠
                if (discount.getDiscount().compareTo(0) > 0) {
                    shoppingCartGoodsResponseVo.setVerCompat(discount.getDiscount());
                }
            }
            shoppingCartGoodsResponseVo.setDeliveryAmount(discountResult.getDeliveryAmount());
            shoppingCartGoodsResponseVo.setDiscountDeliveryAmount(discountResult.getDistributionFee());
            shoppingCartGoodsResponseVo.setThresholdAmount(discount.getThresholdAmount());
            shoppingCartGoodsResponseVo.setIsDiscountDelivery(true);
        }
        else {
            if (activityResponse!=null) {
                // 这里表示有活动, 但是没有参加上
                if(beanDto.getBenefitType() == 1) {
                    String desc = DELIVERY_DISCOUNT_DESC2;
                    shoppingCartGoodsResponseVo.setDeliveryDiscountDesc(String.format(desc, df.format(beanDto.getThresholdAmount().doubleValue() /100) ));
                }
                else {
                    String desc = DELIVERY_DISCOUNT_DESC1;
                    shoppingCartGoodsResponseVo.setDeliveryDiscountDesc(String.format(desc, df.format(beanDto.getThresholdAmount().doubleValue() /100 ),df.format(beanDto.getDiscountAmount().doubleValue() / 100)));
                }

                shoppingCartGoodsResponseVo.setDeliveryAmount(deliveryAmount);
                shoppingCartGoodsResponseVo.setDiscountDeliveryAmount(deliveryAmount);
                shoppingCartGoodsResponseVo.setIsDiscountDelivery(false);
                // fisherman 有活动 使用了优惠券
                boolean isType34 = verifyActivity(discountResult);
                if (isType34) {
                    // 使用了优惠券
                    shoppingCartGoodsResponseVo.setDiscountDeliveryAmount(discountResult.getDistributionFee());
                    String deliveryDiscountDesc = shoppingCartGoodsResponseVo.getDeliveryDiscountDesc();
                    shoppingCartGoodsResponseVo.setDeliveryDiscountDesc(deliveryDiscountDesc+ ",但"+ DELIVERY_DISCOUNT_DESC4);
                }

            } else {
                String desc = DELIVERY_DISCOUNT_DESC3;
                shoppingCartGoodsResponseVo.setDeliveryDiscountDesc(String.format(desc, df.format(deliveryAmount.doubleValue() / 100)));
                shoppingCartGoodsResponseVo.setDeliveryAmount(deliveryAmount);
                shoppingCartGoodsResponseVo.setDiscountDeliveryAmount(deliveryAmount);
                shoppingCartGoodsResponseVo.setIsDiscountDelivery(false);
                // fisherman 确认是否 使用了优惠券
                boolean isType34 = verifyActivity(discountResult);
                if (isType34) {
                    // 使用了优惠券
                    shoppingCartGoodsResponseVo.setDiscountDeliveryAmount(discountResult.getDistributionFee());
                    String deliveryDiscountDesc = shoppingCartGoodsResponseVo.getDeliveryDiscountDesc();
                    shoppingCartGoodsResponseVo.setDeliveryDiscountDesc(deliveryDiscountDesc+ ",但"+ DELIVERY_DISCOUNT_DESC4);
                }
            }
        }

    }

    public void mallDeliveryResponse(ShoppingCartGoodsResponseVo shoppingCartGoodsResponseVo, Long deliveryAmount, CalculationDiscountResult discountResult) {
        shoppingCartGoodsResponseVo.setDeliveryAmount(deliveryAmount);
        shoppingCartGoodsResponseVo.setDiscountDeliveryAmount(0L);
        shoppingCartGoodsResponseVo.setIsDiscountDelivery(false);
        shoppingCartGoodsResponseVo.setTotalAmount(shoppingCartGoodsResponseVo.getTotalAmount() + deliveryAmount);
        shoppingCartGoodsResponseVo.setOriginalTotalAmount(shoppingCartGoodsResponseVo.getOriginalTotalAmount() + deliveryAmount);
    }
    /**
     *  检验是否使用的 配送券
     * @param calculationDiscountResult
     * @return
     */
    private boolean verifyActivity(CalculationDiscountResult calculationDiscountResult) {
        if (calculationDiscountResult!=null && CollectionUtils.isNotEmpty(calculationDiscountResult.getDiscounts())) {
            Discount discount = calculationDiscountResult.getDiscounts().
                    stream().filter(couponResults -> couponResults.getType() != null &&
                    couponResults.getType().compareTo(ActivityTypeEnum.TYPE_34.getCode()) == 0).findFirst().orElse(null);
            return discount != null;
        }
        return false;
    }
}
