/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: CustomerExtendClient
 * @Package cn.freemud.service.thirdparty
 * @Description:
 * @author: song.cai
 * @date: 2019/2/20 16:42
 * @version V1.0
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */

package cn.freemud.service.thirdparty;

import cn.freemud.annotations.LogIgnoreFeign;
import cn.freemud.entities.dto.GetMemberExtendInfoRequestDto;
import cn.freemud.entities.dto.GetMemberExtendInfoResponseDto;
import cn.freemud.entities.dto.GetMemberInfoByIdRequestDto;
import cn.freemud.entities.dto.GetMemberInfoByIdResponseDto;
import cn.freemud.entities.dto.member.GetMemberIdsReq;
import cn.freemud.entities.dto.member.GetMemberIdsResp;
import com.freemud.application.sdk.api.base.BaseResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@FeignClient(name = "CUSTOMER-SERVICE", url = "${saas.customerclient.feign.url}")
@RequestMapping(produces = { "application/json;charset=UTF-8" })
public interface CustomerClient {
    // /**
    // * 根据聚道注册会员
    // */
    // @PostMapping(value = "/customerservice/registerByChannel")
    // MemberRegisterResponseDto registerByChannel(@RequestBody MemberRegisterRequestDto memberRegisterRequestDto);
    //
    // /**
    // * 根据渠道信息查询顾客信息
    // */
    // @PostMapping(value = "/customerservice/getMemberByChannel")
    // GetMemberInfoByChannelResponseDto getMemberInfoByChannel(@RequestBody GetMemberInfoByChannelRequestDto
    // getMemberInfoByChannelRequestDto);
    //
    // /**
    // * 修改unionid
    // */
    // @PostMapping(value = "/customerservice/updateMemberChannel")
    // JSONObject updateUserUnionId(@RequestBody UpdateMemUnionIdRequestDto updateMemUnionIdRequestDto);
    //
     /**
     * 根据会员id获取会员信息
     */
     @PostMapping(value = "/customerservice/getMemberById")
     GetMemberInfoByIdResponseDto getMemberInfoById(@RequestBody GetMemberInfoByIdRequestDto getMemberInfoByIdRequestDto);


    /**
     * 查询memberId的对应的客户下所有会员编号（资产合并前的）
     */
    @PostMapping("/customerservice/customer/getMemberIds")
    @LogIgnoreFeign
    GetMemberIdsResp getMemberIds(@RequestBody GetMemberIdsReq request);


    //
    // /**
    // * 修改顾客信息
    // */
    // @PostMapping(value = "/customerservice/update")
    // JSONObject editMemberInfo(@RequestBody EditMemberInfoRequestDto editMemberInfoRequestDto);
    //
    //
    // /**
    // * 获取用户收货地址列表
    // */
    // @PostMapping(value = "/customerservice/address/getAddressList")
    // GetReceiveAddressListResponseDto getReceiveAddressList(@RequestBody GetReceiveAddressListDto getReceiveListDto);
    //
    // /**
    // * 新增收货地址
    // */
    // @PostMapping(value = "/customerservice/address/add")
    // AddReceiveAddressResponseDto addReceiveAddress(@RequestBody AddReceiveAddressDto addReceiveDto);
    //
    // /**
    // * 修改收货地址
    // */
    // @PostMapping(value = "/customerservice/address/update")
    // UpdateReceiveAddressResponseDto updateReceiveAddress(@RequestBody UpdateReceiveAddressDto
    // updateReceiveAddressDto);
    //
    // /**
    // * 删除收货地址
    // */
    // @PostMapping(value = "/customerservice/address/delete")
    // DeleteReceiveAddressResponseDto deleteReceiveAddress(@RequestBody DeleteReceiveAddressDto
    // deleteReceiveAddressDto);
    //
    //
    // /**
    // * 查询收货地址详情
    // */
    // @PostMapping(value = "/customerservice/address/get")
    // QueryReceiveAddressResponseDto queryReceiveAddressById(@RequestBody QueryReceiveAddressDto
    // queryReceiveAddressDto);

    /**
     * 查询收货地址详情
     */
    @LogIgnoreFeign(logMessage="getMemberExtendInfo")
    @PostMapping(value = "/customerservice/extend/getMemberExtendInfo")
    BaseResponse<GetMemberExtendInfoResponseDto>
            getMemberExtendInfo(@RequestBody GetMemberExtendInfoRequestDto extendInfoRequest);
}
