package cn.freemud.entities.dto.user;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
public class UseScoreRequest {

    /**
     * 商户编号 Y
     */
    private String partnerId;
    /**
     * 会员编号 Y
     */
    private String memberId;
    /**
     * 变动积分 Y
     */
    private Integer changeScore;
    /**
     * Y
     * 操作类型{1消费送积分2积分支付退回3积分签到4手动赠送5等级升级送积分6割接7生日送8注册送9完善送10消费满赠11手动扣减12积分兑换13积分清理14积分支付15消费送积分扣回16等级升级退积分17消费满赠扣回}
     */
    private Integer operationType;
    /**
     * 操作名称{1消费送积分2积分支付退回3积分签到4手动赠送5等级升级送积分6割接7生日送8注册送9完善送10消费满赠11手动扣减12积分兑换13积分清理14积分支付15消费送积分扣回16等级升级退积分17消费满赠扣回}
     */
    private String operationName;

    /**
     * 变动类型{1新增 2扣减}
     */
    private Integer changeType;
    /**
     * 订单编号
     */
    private String orderId;
    /**
     * 机构编码
     */
    private String orgCode;
    /**
     * 机构类型{1总公司2分公司3门店}
     */
    private Integer orgType;
    /**
     * 备注
     */
    private String remark;
    /**
     * 业务ID{调用方保证唯一} Y
     */
    private String idempotencyBussinessId;
    /**
     * Y
     * 业务类型{1注册送 2发放经验值 3等级升级 4等级降级 5积分支付 6消费送积分 7消费满赠 8生日送 9定时送 10储值支付 11储值充值 12完善资料送 13等级升级送积分 14储值卡投放 15会员消费数据增加 16会员消费数据冲正}
     */
    private String idempotencyBussinessType;


    @ApiModelProperty("是否查询子品牌积分规则")
    private Boolean isGetSubBrandRule = false;

    @ApiModelProperty("子品牌编号")
    private String subBrandCode;

    @ApiModelProperty("应用编号")
    private String appId;

}
