package com.freemud.sdk.api.assortment.order.adapter;

import com.freemud.application.sdk.api.membercenter.request.SendPointRequest;
import com.freemud.application.sdk.api.promotioncenter.dto.promotion.DiscountDTO;
import com.freemud.application.sdk.api.promotioncenter.dto.promotion.SendPointDto;
import com.freemud.sdk.api.assortment.order.request.order.ConfirmOrderRequest;
import com.freemud.sdk.api.assortment.order.response.order.QueryOrdersResponse;
import org.springframework.stereotype.Component;

import java.util.UUID;

/**
 * @author haibo.jiang
 * @Description:
 * @date 2019/10/15 17:51
 */
@Component
public class MemberSdkAdapter {

    public SendPointRequest convert2SendPointRequest(ConfirmOrderRequest confirmOrderRequest, QueryOrdersResponse.DataBean.OrderBean orderBean, DiscountDTO discountDTO){
        SendPointDto sendPointDto=discountDTO.getSendPointVo();
        SendPointRequest sendPointRequest=new SendPointRequest();
        sendPointRequest.setPartnerId(orderBean.getCompanyId());
        sendPointRequest.setMemberId(orderBean.getUserId());
        sendPointRequest.setActivityCode(discountDTO.getActivityCode());
        sendPointRequest.setOrderId(orderBean.getOid());
        sendPointRequest.setSendPoint(sendPointDto.getSendPoint());
        sendPointRequest.setMaxPoint(sendPointDto.getMaxNum());
        sendPointRequest.setEndTime(discountDTO.getEndTime());
        sendPointRequest.setIdempotencyBussinessId(UUID.randomUUID().toString());
        sendPointRequest.setIdempotencyBussinessType("17");
        return sendPointRequest;
    }

}
