package com.freemud.application.sdk.api.ordercenter.request.carpark;

import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 发票VO
 * @Auther: yong.huang
 * @Date: 2019/1/28 14:48
 * @Description:
 */
@Data
public class OrderInvoiceReq   {
    /**
     * 订单ID
     */
    private Long id;
    /**
     * 订单ID
     */
    private Long orderId;

    /**
     * 订单编码
     */
    private String orderCode;

    /**
     * 公司编号
     */
    private String partnerId;

    /**
     * 订单商品ID
     */
    private String itemId;

    /**
     * 发票类型 {@link cn.freemud.shared.order.enums.order.OrderInvoiceType#API_DESC}
     */
    private Byte invoiceType;

    /**
     * 发票抬头
     */
    private String title;

    /**
     * 发票内容
     */
    private String content;

    /**
     * 税号
     */
    private String taxNo;

    /**
     * 发票金额 单位分
     */
    private BigDecimal amount;

    /**
     * 发票地址
     */
    private String address;

    /**
     * 电话号码
     */
    private String phoneNo;

    /**
     * 银行账号
     */
    private String bankCardNo;

    /**
     * 开户行
     */
    private String invoiceBank;

    /**
     * 发票URL地址
     */
    private String invoiceUrl;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;
}
