package cn.freemud.service;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.dto.QueryOrdersResponseDto;
import cn.freemud.entities.vo.AppCreateOrderVo;
import cn.freemud.entities.vo.CreateOrderVo;
import cn.freemud.entities.vo.CreatePrepayVo;
import cn.freemud.entities.vo.PaysuccessNoticeMessage;

import java.util.Map;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.6.0
 * @Title: OrderAdapterService
 * @Description: 订单业务适配
 * @author: qin.zhou
 * @date: 2019/9/818:20
 * @Copyright: ${DATE.YARE} www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
public interface OrderAdapterService {

    /**
     * 创建订单
     * @param createOrderVo
     * @return
     */
    BaseResponse createOrderNew(CreateOrderVo createOrderVo);

    /**
     * 麦咖啡创建订单
     * @param createOrderVo
     * @return
     */
    BaseResponse createMCCafeOrder(CreateOrderVo createOrderVo);

    /**
     * 创建预支付
     */
    BaseResponse createPrepay(CreatePrepayVo createPrepayVo);

    /**
     * 支付回调处理
     */
    String paySuccessCallback(PaysuccessNoticeMessage message);

    /**
     * APP下单，下单带商品信息，不经过购物车服务
     */
    BaseResponse appCreateOrder(AppCreateOrderVo createOrderVo);


    /**
     * 支付回调处理
     */
    String mcCafePaySuccessCallback(PaysuccessNoticeMessage message);

}
