package com.freemud.sdk.api.assortment.order.request.order;

import com.freemud.application.sdk.api.ordercenter.enums.AfterSalesType;
import com.freemud.sdk.api.assortment.order.config.BaseConfig;
import lombok.Data;

@Data
public class OrderRefundRequest extends BaseConfig {

    /**
     * 商户号
     */
    private String partnerId;
    /**
     * 订单ID
     */
    private String orderId;

    /**
     * 退款原因
     */
    private String reason;
    /**
     * 订单状态
     */
    private Integer orderStatus;

    //    申请金额，单位分，如果是全部退款，并且传递null,则自动填入 订单用户需支付金额"
    private Long reqAmount = null;

    //    实际金额，单位分，如果是全部退款，并且传递null,则自动填入 订单用户需支付金额"
    private Long actualAmount = null;

    /**
     * 退款备注
     */
    private String remark;

    private String storeId;

    //操作人
    private String operator;
    /**
     *  若为null，默认只做【创建】，售后单状态为【待处理】
     若为2，默认做【创建】+【审核通过】，售后单状态为【退货中】
     若为5，默认做【创建】+【同意并退货完成】，售后单状态【已退货】
     若为4，默认做【创建】+【同意并退款完成】，售后单状态为【完成】
     *
     */
    private Integer createEvent;

    private AfterSalesType afterSalesType;

    private Integer orderClient;
}
