package cn.freemud.entities.dto;

import cn.freemud.entities.dto.delivery.QueryDeliveryTemplateResponse;
import cn.freemud.entities.dto.product.ProductInfo;
import cn.freemud.entities.dto.promotion.CalculationDiscountGoodsDto;
import cn.freemud.entities.dto.promotion.CalculationDiscountResponseDto;
import cn.freemud.entities.dto.promotion.CalculationDiscountResultDto;
import cn.freemud.entities.vo.CreateSpellGroupOrderReq;
import com.freemud.application.sdk.api.ordercenter.request.create.DeliveryContactInfoCreateReq;
import com.freemud.application.sdk.api.storecenter.response.StoreResponse;
import lombok.Data;

import java.util.List;

/**
 * @author freemud
 * @title: CreateSpellGroupOrderDto
 * @projectName order-group
 * @description: TODO
 * @date 2021/4/14下午2:36
 */
@Data
public class CreateSpellGroupOrderDto extends CreateSpellGroupOrderReq {

    /**
     * 用户收货地址信息 ，入参不需要传,通过校验receiveId获取
     */
//    public UserDeliveryInfoDto userDeliveryInfoDto;

    /**
     *当前用户id
     */
    private String userId;
    /**
     *当前用户昵称
     */
    private String nickName;

    /**
     *存储送货地址信息
     */
    List<DeliveryContactInfoCreateReq> deliveryContactInfoCreateReqList;

    /**
     * 存储商品信息
     */
    private List<ProductInfo> products;

    /**
     * 存储促销返回商品算价信息
     */
    private ActivityCalculationDiscountResponseDto  activityCalculationDiscountResponseDto;

    /**
     * 门店信息
     */
    private StoreResponse storeResponse;

    /**
     *配送费信息
     */
    private QueryDeliveryTemplateResponse.DeliveryTemplateInfoVo deliveryTemplateInfoVo;

}
