package cn.freemud.adapter

import cn.freemud.adapter.ActivityAdapter
import cn.freemud.entities.vo.GetShoppingCartGoodsApportionRequestVo
import cn.freemud.service.impl.ShoppingCartNewServiceImpl
import com.alibaba.fastjson.JSON
import com.freemud.api.assortment.datamanager.entity.vo.AssortmentCustomerInfoVo
import com.freemud.api.assortment.datamanager.manager.customer.AssortmentCustomerInfoManager
import org.junit.runner.RunWith
import org.mockito.Mockito
import org.powermock.api.mockito.PowerMockito
import org.powermock.core.classloader.annotations.PrepareForTest
import org.powermock.modules.junit4.PowerMockRunner
import org.powermock.modules.junit4.PowerMockRunnerDelegate
import org.spockframework.runtime.Sputnik
import spock.lang.Specification

/**
 * @author : xh.Z
 * @email : fisherman0510@163.com
 * @Date : 2022/3/7 9:35
 * @description : 
 */
@RunWith(PowerMockRunner.class)
@PowerMockRunnerDelegate(Sputnik.class)
@PrepareForTest()
class DemoSpockMock extends Specification {
    def shoppingCartNewServiceImpl = new ShoppingCartNewServiceImpl()
    def customerInfoManager = PowerMockito.mock(AssortmentCustomerInfoManager)

    void setup() {
        shoppingCartNewServiceImpl.customerInfoManager = customerInfoManager
    }

    def "testMockEnable"() {
        given: "设置请求参数"
        def customerInfoVo = JSON.parseObject("{\"accessToken\":\"\",\"alipayUserId\":\"\",\"appId\":\"wx3f7ca0c75b213380\",\"appSecret\":\"\",\"appsecret\":\"\",\"channel\":\"1\",\"customerId\":\"\",\"devBrand\":\"\",\"devModel\":\"\",\"iappId\":\"7\",\"memberId\":\"3614319825989629832\",\"mobile\":\"17327190802\",\"newMember\":false,\"nickName\":\"SWEET SUGA\",\"openId\":\"o98fP4qjUo7xm-nT-JAaVEk9yBqM\",\"openid\":\"o98fP4qjUo7xm-nT-JAaVEk9yBqM\",\"partnerId\":\"2581\",\"photoUrl\":\"https://thirdwx.qlogo.cn/mmopen/vi_32/zahIlicTNSM0IA0qjOryv6s0SzIhlwW9EpQKvL63GbPhBwficMAibDohDEibSCQU0I5KohibIpp0yL57TWRcVKrRH2A/132\",\"registerTime\":\"2021-02-26 14:10:26\",\"sessionId\":\"eac53a53f8ae62def7f40cb1e47a1bd9791d95a8\",\"sessionKey\":\"GCyyapzbBSM4yXh9AduGOw==\",\"session_key\":\"GCyyapzbBSM4yXh9AduGOw==\",\"storeId\":\"\",\"tableNumber\":\"\",\"thirdPartyMemberID\":\"\",\"thirdPartyPartnerID\":\"\",\"unionId\":\"o7cEm68JPFhbrzqb0a0BcQE-dDVA\",\"wxAppId\":\"wx3f7ca0c75b213380\",\"wxAppid\":\"wx3f7ca0c75b213380\"}"
                , AssortmentCustomerInfoVo.class)
        def getShoppingCartGoodsApportionRequestVo = JSON.parseObject("{\"shoppingCartInfoRequestVo\":{\"activityCode\":\"G1643164091158349\",\"buyType\":0,\"couponCode\":\"88709227085491207040\",\"couponCodes\":[{\"activityCode\":\"G1643164091158349\",\"couponCode\":\"88709227085491207040\",\"couponType\":7,\"discountAmount\":800,\"index\":1}],\"flag\":0,\"menuType\":\"saas\",\"orderType\":1,\"partnerId\":\"2581\",\"reachStoreType\":5,\"sendGoods\":[],\"sessionId\":\"eac53a53f8ae62def7f40cb1e47a1bd9791d95a8\",\"shopId\":\"229830\",\"trackingNo\":\"8283bc4c7e5f4bbb8b357e3c0bef7183\",\"useCouponFlag\":1,\"useCustomerScore\":2,\"version\":\"2.0.60.6\"}}"
                , GetShoppingCartGoodsApportionRequestVo.class)
        def premiumExchangeActivity = getShoppingCartGoodsApportionRequestVo.getPremiumExchangeActivity()
        def shoppingCartInfoRequestVo = getShoppingCartGoodsApportionRequestVo.getShoppingCartInfoRequestVo()

        and: "mock掉接口返回的用户信息"
        Mockito.when(customerInfoManager.getCustomerInfoByObject(Mockito.anyString())).thenReturn(customerInfoVo)

        when: "调用获取用户信息方法"
        def response = shoppingCartNewServiceImpl.getShoppingCartGoods(shoppingCartInfoRequestVo, premiumExchangeActivity)
        then: "验证返回结果是否符合预期值"
    }
}
