package com.freemud.application.sdk.api.ordercenter.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum PayChannelType {

    WECHAT((byte)1,"10211","微信","wechat"),
    ALIPAY((byte)2,"10300","支付宝","alipay"),
    SVC((byte)3,"10102","储值卡","svc"),
    COMB((byte)4,"10212","混合支付","comb"),
    USVCP((byte)5,"10556", "电子风味卡支付","usvcp"),
    ZERO((byte)6,"100000", "0元支付","zero"),
    TIKTOKPAY((byte)7,"10066", "抖音支付","tiktokpay"),
    GIFTCARD((byte)8,"10102","礼品卡","giftCard"),
    POINTS((byte)9,"100001", "积分支付","pointpay"),
    BEATPAY_H5((byte) 12, "30005", "翼支付AppH5支付", "beatpayH5"),
    ;

    private Byte index;
    private String ebcode;
    private String name;
    private String nameEn;

    public static final String API_DESC = "订单支付渠道类型 1:微信 2:储值卡 3:支付宝 4:混合支付,5:电子风味卡支付";

    public static PayChannelType getByIndex(byte index) {
        for (PayChannelType payType : values()) {
            if (payType.getIndex().equals(index)) {
                return payType;
            }
        }
        return null;
    }


    public static PayChannelType getByEbcode(String ebcode) {
        for (PayChannelType payType : values()) {
            if (payType.getEbcode().equals(ebcode)) {
                return payType;
            }
        }
        return WECHAT;
    }
}
