/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: UpdateProductStockRequestDto
 * @Package cn.freemud.entities.dto.shoppingCart
 * @Description: 1.5.4对接库存服务
 * @author: ping.wu
 * @date: 2019/2/20 16:38
 * @version V1.0
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package com.freemud.sdk.api.assortment.order.request.stock;

import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
public class UpdateProductStockRequestDto {

    // 1.增加 2.减少 3.修改
    private String changeType;
    private String channel;
    //是否允许超卖 0=否,1=是 默认是1
    private Integer isOversold;
    private String partnerId;
    private String storeId;

    private List<ProductStock> productStocks;
    //采购中心编号,全家可用
//    private String purchaseCenterId;
    //备注
    private String remark;
    //交易号, maxLength = 36
    private String transNo;
    /**
     * 交易类型 格式类型 yyyy-MM-dd HH:mm:ss
     */
    private String transTime;


    @NoArgsConstructor
    @Data
    public static class ProductStock {
        private String customerCode;
        private String productId;
        private Integer qty;
        private Integer safeQty;
        //虚拟库存数, 可不传，默认为0
        private String virtualQty;

        /**
         * 商品类型 主要库存服务需要区分套餐商品用
         */
        private Integer productType;
    }

}
