package com.freemud.sdk.api.assortment.order.enums;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: PayRefundStatus
 * @Package cn.freemud.enums
 * @Description:
 * @author: jiaxin.liu
 * @date: 2019/5/27 15:09
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
public enum PayRefundStatus {
    SUCCESS(1, "退款成功"),
    FAIL(2, "退款失败"),
    RUNNING(4, "退款中"),
    /**
     * 额外状态码 用于判断逻辑,
     */
    NOT_SUFFICIENT_FUNDS(8200201, "余额不足"),
    COMPATIBILITY_STATUS(9999999, "退款异常");

    private Integer code;
    private String desc;

    PayRefundStatus(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static PayRefundStatus getByPayResultCode(Integer code) {
        if (code == null) {
            return PayRefundStatus.FAIL;
        }
        switch (code) {
            // 退款中状态码需要单独处理
            case 8200305:
                return PayRefundStatus.RUNNING;
            // 重复请求,按照退款中处理
            case 82004005:
                return PayRefundStatus.RUNNING;
            // 退款成功
            case 100:
                return PayRefundStatus.SUCCESS;
            // 已退款订单  当做退款成功处理
            case 101:
                return PayRefundStatus.SUCCESS;
            default:
                return PayRefundStatus.FAIL;
        }
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
