package cn.freemud.entities.dto.delivery;

import lombok.Data;

import java.util.List;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: MallCallbackRequestDto
 * @Package cn.freemud.entities.dto.delivery
 * @Description:
 * @author: ping.wu
 * @date: 22-5-31 下午2:54
 * @Copyright: 2022 www.freemud.cn Inc. All rights reserved.
 */
@Data
public class MallCallbackRequestDto {

    //商户号
    private String partnerId;
    //订单号
    private String tid;
    //物流状态：0-未发货 1-已发货
    private Integer logisticsStatus;
    //物流单号
    private String logisticsNo;
    //物流公司名称
    private String logisticsName;
    //子商品物流状态集合
    private List<LogisticsDetail> goodsList;


    @Data
    public static class LogisticsDetail {
        //原始单id
        private String tid;
        //原始子单id
        private String oid;
        //三方平台唯一编号
        private String specId;
        //非码spuId
        private String spuId;
        //非码skuId
        private String skuId;
        //物流状态：0-未发货 1-已发货
        private Integer logisticsStatus;
        //非码商品编号
        private String productId;
        //限购数量
        private Integer limitNumber;

        //物流单号
        private String logisticsNo;
        //物流公司名称
        private String logisticsName;
    }

}
