package cn.freemud.entities.dto.wechat;

import lombok.Data;

import java.util.List;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.6.0
 * @Title: SyncStatusDto
 * @Package cn.freemud.entities.dto
 * @Description: 简单描述下这个类是做什么用的
 * @author: hang.chai
 * @date: 2019/3/12 15:00
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Data
public class WechatReportOrderDto {
    /**
     * 子商户号
     */
    private String sub_mchid;
    /**
     * 子商户APPID,非必填
     */
    private String sub_appid;
    /**
     * 门店编号
     */
    private String out_shop_no;
    /**
     * 用户子标识 ,非必填
     */
    private String sub_openid;
    /**
     * 登录票据(微信用户登录接口返回的登 录票据 公众号，填写access_token； 小程序，填写session_key；)
     */
    private String login_token;
    /**
     * 总价,单位为分
     */
    private int total_amount;
    /**
     * 优惠金额,单位为分
     */
    private int discount_amount;
    /**
     * 微信支付订单号（status 为 PAY_SUCCESS时必填）
     */
    private String transaction_id;
    /**
     * 服务商支付订单号（status为PAY_SUCCESS时 必填）
     */
    private String out_trade_no;
    /**
     * 服务商订单号
     */
    private String out_order_no;
    /**
     * 菜品列表
     */
    private List<DishInfo> dish_list;
    /**
     * 消费人数
     */
    private int people_count;

    @Data
    public static class DishInfo{
        /**
         * 商户菜品ID
         */
        private String out_dish_no;
        /**
         * 菜品名称
         */
        private String name;
        /**
         * 菜品单价,单位为分
         */
        private int price;
        /**
         * 菜品数量
         */
        private float count;
    }
}
