package cn.freemud.management.adapter;

import com.alibaba.fastjson.JSONObject;
import com.freemud.application.sdk.api.base.SDKCommonBaseContextWare;
import com.freemud.application.sdk.api.ordercenter.request.OrderExtInfoDto;
import com.freemud.sdk.api.assortment.order.request.order.MultiOrderRefundRequest;
import com.freemud.sdk.api.assortment.order.response.order.QueryOrdersResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: PaymentSdkAdapter
 * @Package cn.freemud.management.adapter
 * @Description:
 * @author: shuhu.hou
 * @date: 2020/4/24 11:45
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Component
public class PaymentSdkAdapter {

    @Value("${saas.refund.notify.callback}")
    private String refundNotifyCallback;

    public com.freemud.sdk.api.assortment.payment.request.OrderRefundRequest getOrderRefundRequest(QueryOrdersResponse.DataBean.OrderBean orderBean, BigDecimal refundAmount) {
        com.freemud.sdk.api.assortment.payment.request.OrderRefundRequest refundRequestDTO = new com.freemud.sdk.api.assortment.payment.request.OrderRefundRequest();
        refundRequestDTO.setPartnerId(orderBean.getCompanyId());
        refundRequestDTO.setStoreId(orderBean.getShopId());
        refundRequestDTO.setOrgTransId(orderBean.getOid());
        refundRequestDTO.setRefundAmount(refundAmount.longValue());
        refundRequestDTO.setNotifyUrl(refundNotifyCallback);
        OrderExtInfoDto orderExtInfoDto = JSONObject.parseObject(orderBean.getExtInfo(), OrderExtInfoDto.class);
        refundRequestDTO.setAppId(orderExtInfoDto.getAppid());
        refundRequestDTO.setOrgPayFmId(orderBean.getPayVoucher());
        refundRequestDTO.setOpenid(orderExtInfoDto.getOpenid());
        refundRequestDTO.setRefundId(getRefundSerialNo());
        return refundRequestDTO;
    }

    public MultiOrderRefundRequest getMultiOrderPayRefundRequest(QueryOrdersResponse.DataBean.OrderBean orderBean, BigDecimal refundAmount) {
        MultiOrderRefundRequest multiQueryRequest = new MultiOrderRefundRequest();
        multiQueryRequest.setStationId("1");
        multiQueryRequest.setPartnerId(orderBean.getCompanyId());
        multiQueryRequest.setStoreId(orderBean.getShopId());
        multiQueryRequest.setFmId("");
        multiQueryRequest.setRefundAmount(Long.valueOf(String.valueOf(refundAmount)));
        multiQueryRequest.setRefundTradeNo(getRefundSerialNo().toString());
        multiQueryRequest.setStoreId(orderBean.getShopId());
        multiQueryRequest.setNotifyUrl(refundNotifyCallback);
        multiQueryRequest.setVer("V1");
        multiQueryRequest.setVer3(false);
        multiQueryRequest.setOutOrderNo(orderBean.getOid());
        return multiQueryRequest;
    }

    private Long getRefundSerialNo() {
        return System.currentTimeMillis() + (int) (Math.random() * 9000) + 1000;
    }

}
