package com.freemud.sdk.api.assortment.order.response.order;

import lombok.Data;

@Data
public class CreateOrderFlowResponse {

    private String code;
    private String message;
    private String ver;

    private CreateOrderResponseVo data;

    public CreateOrderFlowResponse(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public CreateOrderFlowResponse(String code, String message, CreateOrderResponseVo data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }

    @Data
    public static class CreateOrderResponseVo {

        private String orderId;

        private String wxAppid;

        private String timestamp;

        private String nonceStr;

        private String packageX;

        private String signType;

        private String sign;

        /**
         * 是否支持成功 支付金额为0，现为商品券时返回true，其余为false
         */
        private Boolean paySuccess;
        /**
         * 非码支付商户号  用户数据上报
         */
        private String fmId;

    }
}
