package com.freemud.application.sdk.api.ordercenter.util;


import com.freemud.application.sdk.api.ordercenter.constant.VersionConstant;
import com.freemud.application.sdk.api.ordercenter.enums.ResponseResultEnum;
import com.freemud.application.sdk.api.ordercenter.response.OrderBaseResp;

/**
 * @title: ResponseUtil
 * @package: cn.freemud.utils
 * @author: jiale<loverichy8 @ gmail.com>
 * @date: 2017/11/29
 * @description:
 */
public class ResponseUtil {

    /**
     * @param <T>
     * @return
     */
    public static <T> OrderBaseResp<T> success() {
        return new OrderBaseResp<>(VersionConstant.VERSION_1, ResponseResultEnum.SUCCESS.getCode(),"success",null);
    }

    /**
     * @param t
     * @param <T>
     * @return
     */
    public static <T> OrderBaseResp<T> success(T t) {
        return new OrderBaseResp<>(VersionConstant.VERSION_1, ResponseResultEnum.SUCCESS.getCode(),"success",  t);
    }

    public static <T> OrderBaseResp<T> error(ResponseResultEnum status) {
        return new OrderBaseResp<>(VersionConstant.VERSION_1, status.getCode(), status.getMessage(),null);
    }

    /**
     * @param code
     * @return
     */
    public static <T> OrderBaseResp<T> error(String code) {
        return new OrderBaseResp<>(VersionConstant.VERSION_1, code,null,null);
    }

    /**
     * @param code
     * @param message
     * @return
     */
    public static <T> OrderBaseResp<T> error(String code, String message) {
        return new OrderBaseResp<>(VersionConstant.VERSION_1, code, message,null);
    }

    public static <T> OrderBaseResp<T> error(String code, String message, T t) {
        return new OrderBaseResp<>(VersionConstant.VERSION_1,code, message,  t);
    }

}
