package cn.freemud.service.impl;

import cn.freemud.entities.dto.UserLoginInfoDto;
import cn.freemud.entities.dto.activity.ActivityQueryDto;
import cn.freemud.entities.dto.calculate.ActivityCalculationDiscountResponseDto;
import cn.freemud.entities.dto.shoppingCart.ShoppingCartGoodsDto;
import cn.freemud.entities.vo.*;
import cn.freemud.enums.ActivityTypeEnum;
import cn.freemud.service.IPromotionService;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Service("buyMSendNCouponDiscountService")
public class BuyMSendNCouponDiscountServiceImpl implements IPromotionService {


    @Override
    public void updateShoppingCartGoodsDiscount(CouponPromotionVO couponPromotionVO, ActivityQueryDto activityQueryDto,
                                                ActivityCalculationDiscountResponseDto.CalculationDiscountResult calculationDiscountResult,
                                                List<CartGoods> cartGoodsList, ShoppingCartGoodsResponseVo shoppingCartGoodsResponseVo,
                                                UserLoginInfoDto userLoginInfoDto, ShoppingCartInfoRequestVo shoppingCartInfoRequestVo) {

        if (calculationDiscountResult == null || CollectionUtils.isEmpty(calculationDiscountResult.getCouponDiscounts())) {
            return;
        }
        List<ActivityCalculationDiscountResponseDto.CalculationDiscountResult.CouponResults> couponResultsList = calculationDiscountResult.getCouponDiscounts();

        List<ActivityCalculationDiscountResponseDto.CalculationDiscountResult.CouponResults> collect = couponResultsList.stream().filter(c -> ActivityTypeEnum.TYPE_330.getCode().equals(c.getActivityType())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            return;
        }

        for (ActivityCalculationDiscountResponseDto.CalculationDiscountResult.Goods goods : calculationDiscountResult.getGoods()) {
            if (CollectionUtils.isEmpty(goods.getDiscounts())) {
                continue;
            }
            List<ActivityCalculationDiscountResponseDto.CalculationDiscountResult.Goods.GoodsDiscount> goodsDiscounts = goods.getDiscounts().stream().filter(c -> ActivityTypeEnum.TYPE_330.getCode().equals(c.getType())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(goodsDiscounts)) {
                continue;
            }
//            List<CartGoods> addSendGoodsList = new ArrayList<>();
            for (CartGoods cartGoods : cartGoodsList) {
                if (Objects.equals(goods.getCartGoodsUid(), cartGoods.getCartGoodsUid())) {
                    Integer actualGoodsNumber = goodsDiscounts.get(0).getActualGoodsNumber();
                    if (cartGoods.getQty() > actualGoodsNumber) {
//                        CartGoods cartGood = new CartGoods();
//                        BeanUtils.copyProperties(cartGoods, cartGood);
//                        cartGood.setQty(actualGoodsNumber);
//                        cartGood.setAmount(0L);
//                        cartGoods.setQty(cartGoods.getQty() - actualGoodsNumber);
                        cartGoods.setAmount(goods.getRealAmount());
//                        addSendGoodsList.add(cartGood);
                    }
                    if (cartGoods.getQty() == actualGoodsNumber) {
                        cartGoods.setAmount(0L);
                    }
                }
            }
//            cartGoodsList.addAll(addSendGoodsList);
        }

    }

    @Override
    public void updateShoppingCartGoodsApportion(ShoppingCartGoodsResponseVo shoppingCartGoodsResponseVo,
                                                 ActivityCalculationDiscountResponseDto.CalculationDiscountResult calculationDiscountResult,
                                                 ShoppingCartGoodsDto shoppingCartGoodsDto, CreateOrderVo.PremiumExchangeActivity premiumExchangeActivity,
                                                 ShoppingCartInfoRequestVo shoppingCartInfoRequestVo) {

    }


}
