package cn.freemud.entities.dto.delivery;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

/**
 * @author wanghanghang
 * @title: QueryDeliveryTemplateRequest
 * @projectName order-group
 * @description: 查询商城快递费用request
 * @date 2021/4/20上午11:03
 */
@Data
public class QueryDeliveryTemplateRequest {

    @NotEmpty
    @ApiModelProperty(value = "商户号")
    private String partnerId;

    @NotEmpty
    @ApiModelProperty(value = "城市号")
    private String province;

    @NotNull
    @ApiModelProperty(value = "订单金额")
    private Integer orderAmount;

    @NotNull
    @ApiModelProperty(value = "商品数量")
    private Integer count;

}
