package cn.freemud.amp.service;

import cn.freemud.amp.config.DlSendCouponMqConfig;
import cn.freemud.amqp.Header;
import cn.freemud.amqp.MQAction;
import cn.freemud.amqp.MQMessage;
import cn.freemud.amqp.MQService;
import cn.freemud.utils.AppLogUtil;
import com.alibaba.fastjson.JSONObject;
import com.freemud.application.sdk.api.ordercenter.response.orderInfo.OrderInfoReqs;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SendCouponService {

    @Autowired
    private MQService mqService;

    public void sendCouponMq(OrderInfoReqs request) {
        AppLogUtil.infoLog("sendCouponMq", JSONObject.toJSONString(request.getOrderCode()), null);
        Header header = new Header(MQAction.INSERT.getAction(), "order-application-service", "1", DlSendCouponMqConfig.QUEUE_NAME);
        MQMessage<OrderInfoReqs> message = new MQMessage<>(header, request);
        mqService.convertAndSend(DlSendCouponMqConfig.EXCHANGE_NAME, DlSendCouponMqConfig.QUEUE_ROUTING_KEY, message);
    }

}
