/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: ProductVo
 * @Package cn.freemud.entities.vo
 * @Description:
 * @author: liming.guo
 * @date: 2018/5/15 15:11
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.vo;

import cn.freemud.entities.dto.ProductGroupDto;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
public class SpuProductVo {

    /**
     *  商品ID
     */
    private String pid;
    /**
     *  商品spuId
     */
    private String spuId;

    private String skuId;
    /**
     *  spu商品名称
     */
    private String spuName;
    /**
     *  商品名称
     */
    private String name;
    /**
     *  默认spu销售价
     */
    private Long defaultPrice;
    /**
     * 最终价格
     */
    private Long finalPrice;
    /**
     *  默认图片
     */
    private String picture;
    /**
     *  属性信息
     */
    List<ProductGroupDto>  productGroups;
    /**
     * SKU信息
     */
    private List<SkuProductVo> skuList;
    /**
     * 商品规格信息
     */
    private List<SpecificationGroupVo> specificationGroupList;
    /**
     * 商品标签信息
     */
    List<ProductLabel> productLabels;
    /**
     *  商品类型  1=普通商品,2=附加商品,3=组合商品，4=固定套餐，5=组合套餐
     */
    private Integer type;
    /**
     *  描述
     */
    private String specification;
    /**
     *  备注
     */
    private String remark;
    /**
     * 商品排序
     */
    private int sequence;
    /**
     *  商品数量
     */
    private Integer qty;
    /**
     * 商品状态   1 下架 2 上架 3 售罄 ，已卖光
     */
    private Integer status;
    /**
     * 状态描述
     */
    private String statusDesc;
    /**
     * 是否有规格信息
     */
    private boolean hasSku;
    /**
     * 腾讯商品推荐id
     */
    private String traceId;
    /**
     * 是否有折扣信息
     */
    private boolean hasDiscount;
    /**
     * 每笔订单限制购买数量
     */
    private Integer limitPerOrder;
    /**
     * 折扣信息描述
     */
    private String discountDesc;

    /**
     * 商品券生效开始时间
     */
    private String startDate;
    /**
     * 商品券生效截止时间
     */
    private String endDate;

    private Integer stockLimit;

    /**
     * 1.5.5版本添加
     * 商品参与活动类型(61:买一赠一)
     */
    private Integer activityType;
    /**
     * 1.5.5版本添加
     * 商品参与活动名称
     */
    private String activityName;
    @Data
    @NoArgsConstructor
    public static class ProductLabel {
        /**
         * 标签名称
         */
        private String labelName;

    }

    @NoArgsConstructor
    @Data
    public static class SkuProductVo {
        /**
         * sku id
         */
        private String skuId;
        /**
         * sku 名称
         */
        private String skuName;
        /**
         * 最终价格
         */
        private Long finalPrice;
        /**
         * 市场价
         */
        private Long originalPrice;
        /**
         * sku 状态
         */
        private Integer status;
        /**
         * 状态描述
         */
        private String statusDesc;
        /**
         * 规格id
         */
        private String []specValueId;
    }
    @NoArgsConstructor
    @Data
    public static class SpecificationGroupVo {

        /**
         * 规格名称 杯型 ，加料
         */
        private String specName;
        /**
         * 规格id 1001
         */
        private String specId;
        /**
         *  规格信息
         */
        private List<SpecValueVo> specValueVos;

        @NoArgsConstructor
        @Data
        public static class SpecValueVo {
            /**
             * 规格id 1001
             */
            private String specId;
            /**
             *  规格值 id   100100
             */
            private String specValueId;
            /**
             *  规格值名称  大杯，小杯
             */
            private String specValueName;
        }
    }
}
