package cn.freemud.entities.dto;

import com.google.gson.annotations.SerializedName;
import lombok.Data;

import java.util.List;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: ActionListDto
 * @Package cn.freemud.entities.dto
 * @Description: 简单描述下这个类是做什么用的
 * @author: zhenghuan.yang
 * @date: 2018/9/20 16:07
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Data
public class ActionListDto {
    @SerializedName("action_list")
    private List<ActionList> actionList;
    @Data
    public static class ActionList{
        @SerializedName("action_type")
        private String actionType;
        @SerializedName("action_time")
        private Long actionTime;
        @SerializedName("action_param")
        private ActionParam actionParam;
        @SerializedName("trace_id")
        private String traceId;
        @Data
        public static class ActionParam{
            @SerializedName("product_id")
            private String productId;
            @SerializedName("product_name")
            private String productName;
            /**
             * 商品排在曝光列表哪个位置，从1开始计数
             */
            private Integer position;
        }
    }
}
