/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: PushMessageTokenDto
 * @Package cn.freemud.entities.dto
 * @Description:
 * @author: liming.guo
 * @date: 2018/5/31 11:12
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
public class PushMessageNoticeDto {

    /**
     * 版本号  默认1
     */
    private String ver;
    /**
     * 商户ID
     */
    private String partnerId;
    /**
     * 门店ID
     */
    private String storeId;
    /**
     * 推送目标 1 小程序 2 pos机
     */
    private Integer targetType;

    private Integer ttl = 30;
    /**
     * 推送目标 ID targetId
     */
    private String targetId;

    private Integer cmd;

    private String data;

    @Data
    @NoArgsConstructor
    public static class Message {

        private Integer type;

        private Content content;

        @Data
        @NoArgsConstructor
        public static class Content {

            @JsonProperty("take_code")
            private String take_code;

            private String queueIndex;

            private String oid;

        }
    }

}
