package cn.freemud.service.thirdparty;

import cn.freemud.entities.dto.GetUserScoreUserDetailDto;
import cn.freemud.entities.vo.GetUserScoreUseDetailVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

/**
 * All rights Reserved, Designed By www.freemud.com
 *
 * @version V1.0
 * @Title:
 * @Package: cn.freemud.service.thirdparty
 * @Descripttion:
 * @author: shuhu.hou
 * @date: 2019/5/11
 * @Copyright: 2017 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目.
 */
@FeignClient(name = "customer-application-service", url = "${saas.customScoreClient.feign.url}")
@RequestMapping(produces = {"application/json;charset=UTF-8"})
public interface CustomScoreClient {
    /**
     * 用户可用积分
     */
    @PostMapping(value = "/user/scoreUseDetail")
    GetUserScoreUserDetailDto getUserScoreUseDetail(@RequestBody GetUserScoreUseDetailVo getUserScoreUseDetailVo);
}
